/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.loghub.client;

import com.aliyun.openservices.log.Client;
import com.aliyun.openservices.log.common.Consts;
import com.aliyun.openservices.log.common.ConsumerGroup;
import com.aliyun.openservices.log.common.ConsumerGroupShardCheckPoint;
import com.aliyun.openservices.log.exception.LogException;
import com.aliyun.openservices.log.response.BatchGetLogResponse;
import com.aliyun.openservices.loghub.client.exceptions.LogHubCheckPointException;
import java.util.ArrayList;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;

public class LogHubClientAdapter {
    private Client mClient;
    private ReadWriteLock mReadWrtlock = new ReentrantReadWriteLock();
    private final String mProject;
    private final String mStream;
    private final String mConsumerGroup;
    private final String mConsumer;
    private final String mUserAgent;
    private static final Logger logger = Logger.getLogger(LogHubClientAdapter.class);

    public LogHubClientAdapter(String endPoint, String accessKeyId, String accessKey, String stsToken, String project, String stream, String consumerGroup, String consumer) {
        this.mClient = new Client(endPoint, accessKeyId, accessKey);
        if (stsToken != null) {
            this.mClient.SetSecurityToken(stsToken);
        }
        this.mProject = project;
        this.mStream = stream;
        this.mConsumerGroup = consumerGroup;
        this.mConsumer = consumer;
        this.mUserAgent = "[consumer-group-java]" + consumerGroup;
        this.mClient.setUserAgent(this.mUserAgent);
    }

    public void SwitchClient(String endPoint, String accessKeyId, String accessKey, String stsToken) {
        this.mReadWrtlock.writeLock().lock();
        this.mClient = new Client(endPoint, accessKeyId, accessKey);
        if (stsToken != null) {
            this.mClient.SetSecurityToken(stsToken);
        }
        this.mReadWrtlock.writeLock().unlock();
    }

    public void CreateConsumerGroup(int timeoutInSec, boolean inOrder) throws LogException {
        this.mReadWrtlock.readLock().lock();
        try {
            this.mClient.CreateConsumerGroup(this.mProject, this.mStream, new ConsumerGroup(this.mConsumerGroup, timeoutInSec, inOrder));
        }
        finally {
            this.mReadWrtlock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsumerGroup GetConsumerGroup() throws LogException {
        this.mReadWrtlock.readLock().lock();
        try {
            for (ConsumerGroup consumerGroup : this.mClient.ListConsumerGroup(this.mProject, this.mStream).GetConsumerGroups()) {
                if (consumerGroup.getConsumerGroupName().compareTo(this.mConsumerGroup) != 0) continue;
                ConsumerGroup consumerGroup2 = consumerGroup;
                return consumerGroup2;
            }
        }
        finally {
            this.mReadWrtlock.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean HeartBeat(ArrayList<Integer> shards, ArrayList<Integer> response) {
        this.mReadWrtlock.readLock().lock();
        response.clear();
        try {
            response.addAll(this.mClient.HeartBeat(this.mProject, this.mStream, this.mConsumerGroup, this.mConsumer, shards).GetShards());
            boolean bl = true;
            return bl;
        }
        catch (LogException e) {
            logger.warn((Object)(e.GetErrorCode() + ": " + e.GetErrorMessage()));
        }
        finally {
            this.mReadWrtlock.readLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void UpdateCheckPoint(int shard, String consumer, String checkpoint) throws LogException {
        this.mReadWrtlock.readLock().lock();
        try {
            this.mClient.UpdateCheckPoint(this.mProject, this.mStream, this.mConsumerGroup, consumer, shard, checkpoint);
        }
        finally {
            this.mReadWrtlock.readLock().unlock();
        }
    }

    public String GetCheckPoint(int shard) throws LogException, LogHubCheckPointException {
        this.mReadWrtlock.readLock().lock();
        ArrayList checkPoints = null;
        try {
            checkPoints = this.mClient.GetCheckPoint(this.mProject, this.mStream, this.mConsumerGroup, shard).GetCheckPoints();
        }
        finally {
            this.mReadWrtlock.readLock().unlock();
        }
        if (checkPoints == null || checkPoints.size() == 0) {
            throw new LogHubCheckPointException("fail to get shard checkpoint");
        }
        return ((ConsumerGroupShardCheckPoint)checkPoints.get(0)).getCheckPoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String GetCursor(int shard, Consts.CursorMode mode) throws LogException {
        this.mReadWrtlock.readLock().lock();
        try {
            String string = this.mClient.GetCursor(this.mProject, this.mStream, shard, mode).GetCursor();
            return string;
        }
        finally {
            this.mReadWrtlock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String GetCursor(int shard, long time) throws LogException {
        this.mReadWrtlock.readLock().lock();
        try {
            String string = this.mClient.GetCursor(this.mProject, this.mStream, shard, time).GetCursor();
            return string;
        }
        finally {
            this.mReadWrtlock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BatchGetLogResponse BatchGetLogs(int shard, int lines, String cursor) throws LogException {
        this.mReadWrtlock.readLock().lock();
        try {
            BatchGetLogResponse response;
            BatchGetLogResponse batchGetLogResponse = response = this.mClient.BatchGetLog(this.mProject, this.mStream, shard, lines, cursor);
            return batchGetLogResponse;
        }
        finally {
            this.mReadWrtlock.readLock().unlock();
        }
    }
}

