/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.loghub.client;

import com.aliyun.openservices.loghub.client.LogHubClientAdapter;
import com.aliyun.openservices.loghub.client.LogThreadFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class LogHubHeartBeat {
    private ScheduledExecutorService threadpool;
    private LogHubClientAdapter mLogHubClientAdapter;
    private boolean running = false;
    private final long mHeartBeatIntervalMillis;
    private ArrayList<Integer> mHeldShards;
    private HashSet<Integer> mHeartShards;
    private static final Logger logger = Logger.getLogger(LogHubHeartBeat.class);
    private static final long STOP_WAIT_TIME_MILLIS = 2000L;

    public LogHubHeartBeat(LogHubClientAdapter logHubClientAdapter, long heartBeatIntervalMillis) {
        this.mLogHubClientAdapter = logHubClientAdapter;
        this.mHeartBeatIntervalMillis = heartBeatIntervalMillis;
        this.mHeldShards = new ArrayList();
        this.mHeartShards = new HashSet();
    }

    public void Start() {
        this.threadpool = Executors.newScheduledThreadPool(1, new LogThreadFactory());
        this.threadpool.scheduleWithFixedDelay(new HeartBeatRunnable(), 0L, this.mHeartBeatIntervalMillis, TimeUnit.MILLISECONDS);
        this.running = true;
    }

    public void Stop() {
        if (this.threadpool != null) {
            this.threadpool.shutdown();
            try {
                if (!this.threadpool.awaitTermination(2000L, TimeUnit.MILLISECONDS)) {
                    this.threadpool.shutdownNow();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.running = false;
    }

    public synchronized void GetHeldShards(ArrayList<Integer> shards) {
        shards.clear();
        shards.addAll(this.mHeldShards);
    }

    public synchronized void RemoveHeartShard(int shard) {
        this.mHeartShards.remove(shard);
    }

    protected synchronized void HeartBeat() {
        if (this.mLogHubClientAdapter.HeartBeat(new ArrayList<Integer>(this.mHeartShards), this.mHeldShards)) {
            this.mHeartShards.addAll(this.mHeldShards);
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    private class HeartBeatRunnable
    implements Runnable {
        private HeartBeatRunnable() {
        }

        @Override
        public void run() {
            try {
                LogHubHeartBeat.this.HeartBeat();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

