/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.reader;

import com.alicloud.openservices.tablestore.AsyncClientInterface;
import com.alicloud.openservices.tablestore.TableStoreCallback;
import com.alicloud.openservices.tablestore.model.RowQueryCriteria;
import com.alicloud.openservices.tablestore.reader.PrimaryKeyWithTable;
import com.alicloud.openservices.tablestore.reader.ReaderEvent;
import com.alicloud.openservices.tablestore.reader.ReaderEventHandler;
import com.alicloud.openservices.tablestore.reader.ReaderGroup;
import com.alicloud.openservices.tablestore.reader.ReaderStatistics;
import com.alicloud.openservices.tablestore.reader.RowReadResult;
import com.alicloud.openservices.tablestore.reader.TableStoreReaderConfig;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.InsufficientCapacityException;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.dsl.Disruptor;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;

public class ReaderBucket {
    private final Disruptor<ReaderEvent> disruptor;
    private final RingBuffer<ReaderEvent> ringBuffer;
    private final ReaderEventHandler readerEventHandler;
    private final ExecutorService disruptorExecutor;
    private final TableStoreReaderConfig config;
    private final TableStoreCallback<PrimaryKeyWithTable, RowReadResult> callback;

    public ReaderBucket(AsyncClientInterface ots, Semaphore semaphore, TableStoreReaderConfig config, TableStoreCallback<PrimaryKeyWithTable, RowReadResult> callback, Executor executor, ReaderStatistics statistics) {
        ReaderEvent.ReaderEventFactory factory = new ReaderEvent.ReaderEventFactory();
        this.callback = callback;
        this.disruptorExecutor = Executors.newFixedThreadPool(1);
        this.config = config;
        this.disruptor = new Disruptor((EventFactory)factory, this.config.getBufferSize(), (Executor)this.disruptorExecutor);
        this.ringBuffer = this.disruptor.getRingBuffer();
        this.readerEventHandler = new ReaderEventHandler(ots, config, executor, semaphore, callback, statistics);
        this.disruptor.handleEventsWith(new EventHandler[]{this.readerEventHandler});
        this.disruptor.start();
    }

    public void setCallback(TableStoreCallback<PrimaryKeyWithTable, RowReadResult> callback) {
        this.readerEventHandler.setCallback(callback);
    }

    public boolean addPrimaryKeyWithTable(PrimaryKeyWithTable pkWithTable, ReaderGroup readerGroup) {
        try {
            long sequence = this.ringBuffer.tryNext();
            ReaderEvent event = (ReaderEvent)this.ringBuffer.get(sequence);
            event.setValue(pkWithTable, readerGroup);
            this.ringBuffer.publish(sequence);
            return true;
        }
        catch (InsufficientCapacityException e) {
            return false;
        }
    }

    public void addSignal(CountDownLatch latch, ReaderEvent.EventType type) {
        while (true) {
            try {
                long sequence = this.ringBuffer.tryNext();
                ReaderEvent event = (ReaderEvent)this.ringBuffer.get(sequence);
                event.setValue(latch, type);
                this.ringBuffer.publish(sequence);
                return;
            }
            catch (InsufficientCapacityException e) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }

    public void setRowQueryCriteria(RowQueryCriteria rowQueryCriteria) {
        this.readerEventHandler.setRowQueryCriteria(rowQueryCriteria);
    }

    public RingBuffer<ReaderEvent> getRingBuffer() {
        return this.ringBuffer;
    }

    public synchronized void close() {
        this.disruptor.shutdown();
        this.disruptorExecutor.shutdown();
    }
}

