/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.timeserieswriter.group;

import com.alicloud.openservices.tablestore.core.CallbackImpledFuture;
import com.alicloud.openservices.tablestore.model.timeseries.TimeseriesTableRow;
import com.alicloud.openservices.tablestore.timeserieswriter.TimeseriesWriterResult;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeseriesGroup {
    private Logger logger = LoggerFactory.getLogger(TimeseriesGroup.class);
    private static AtomicLong idGenerator = new AtomicLong(0L);
    private final long groupId;
    private final int totalCount;
    private final AtomicInteger remainCounter;
    private final AtomicReferenceArray<TimeseriesWriterResult.TimeseriesRowChangeStatus> rowChangeStatusList;
    private final CallbackImpledFuture<TimeseriesTableRow, TimeseriesWriterResult> future = new CallbackImpledFuture();

    public TimeseriesGroup(int totalCount) {
        this.totalCount = totalCount;
        this.remainCounter = new AtomicInteger(totalCount);
        this.rowChangeStatusList = new AtomicReferenceArray(totalCount);
        this.groupId = idGenerator.incrementAndGet();
    }

    public CallbackImpledFuture<TimeseriesTableRow, TimeseriesWriterResult> getFuture() {
        return this.future;
    }

    public void succeedOneRow(TimeseriesTableRow timeseriesTableRow) {
        this.finishOneRow(true, timeseriesTableRow, null);
    }

    public void failedOneRow(TimeseriesTableRow timeseriesTableRow, Exception exception) {
        this.finishOneRow(false, timeseriesTableRow, exception);
    }

    private void finishOneRow(boolean isSucceed, TimeseriesTableRow timeseriesTableRow, Exception exception) {
        int counter = this.remainCounter.decrementAndGet();
        if (counter < 0) {
            IllegalStateException exp = new IllegalStateException(String.format("[%d] WriterResult shouldn't finish more rows than total count", this.groupId));
            this.logger.error("Group OnFinishOneRow Failed", (Throwable)exp);
            throw exp;
        }
        TimeseriesWriterResult.TimeseriesRowChangeStatus status = new TimeseriesWriterResult.TimeseriesRowChangeStatus(isSucceed, timeseriesTableRow, exception);
        this.rowChangeStatusList.set(this.totalCount - counter - 1, status);
        if (counter == 0) {
            this.completeGroup();
        }
    }

    private void completeGroup() {
        TimeseriesWriterResult timeseriesWriterResult = new TimeseriesWriterResult(this.totalCount, this.rowChangeStatusList);
        this.future.onCompleted(null, timeseriesWriterResult);
    }

    public long getGroupId() {
        return this.groupId;
    }
}

