/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.timestream.model;

import com.alicloud.openservices.tablestore.AsyncClient;
import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.model.GetRangeRequest;
import com.alicloud.openservices.tablestore.model.GetRangeResponse;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.Row;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutionException;

public class GetRangeIterator
implements Iterator<Row> {
    private AsyncClient asyncClient;
    private GetRangeRequest request;
    private GetRangeResponse response = null;
    private Iterator<Row> rowIterator;

    public GetRangeIterator(AsyncClient asyncClient, GetRangeRequest request) {
        this.asyncClient = asyncClient;
        this.request = request;
        this.fetchData(request);
    }

    private void fetchData(GetRangeRequest request) {
        try {
            this.response = this.asyncClient.getRange(request, null).get();
        }
        catch (InterruptedException e) {
            throw new ClientException(String.format("The thread was interrupted: %s", e.getMessage()));
        }
        catch (ExecutionException e) {
            throw new ClientException("The thread was aborted", e);
        }
        this.rowIterator = this.response.getRows().iterator();
    }

    private boolean isBufferHasData() {
        return this.rowIterator.hasNext();
    }

    @Override
    public boolean hasNext() {
        if (this.isBufferHasData()) {
            return true;
        }
        PrimaryKey token = this.response.getNextStartPrimaryKey();
        while (token != null) {
            this.request.getRangeRowQueryCriteria().setInclusiveStartPrimaryKey(token);
            this.fetchData(this.request);
            if (this.isBufferHasData()) {
                return true;
            }
            token = this.response.getNextStartPrimaryKey();
        }
        return false;
    }

    @Override
    public Row next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.rowIterator.next();
    }

    @Override
    public void remove() {
        throw new RuntimeException("GetRangeIterator do not support remove().");
    }
}

