/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.ots.thirdparty.org.apache.impl.cookie;

import com.aliyun.ots.thirdparty.org.apache.annotation.Immutable;
import com.aliyun.ots.thirdparty.org.apache.cookie.Cookie;
import com.aliyun.ots.thirdparty.org.apache.cookie.CookieAttributeHandler;
import com.aliyun.ots.thirdparty.org.apache.cookie.CookieOrigin;
import com.aliyun.ots.thirdparty.org.apache.cookie.CookieRestrictionViolationException;
import com.aliyun.ots.thirdparty.org.apache.cookie.MalformedCookieException;
import com.aliyun.ots.thirdparty.org.apache.cookie.SetCookie;
import com.aliyun.ots.thirdparty.org.apache.util.Args;
import com.aliyun.ots.thirdparty.org.apache.util.TextUtils;

@Immutable
public class BasicPathHandler
implements CookieAttributeHandler {
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        cookie.setPath(!TextUtils.isBlank(value) ? value : "/");
    }

    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        if (!this.match(cookie, origin)) {
            throw new CookieRestrictionViolationException("Illegal path attribute \"" + cookie.getPath() + "\". Path of origin: \"" + origin.getPath() + "\"");
        }
    }

    public boolean match(Cookie cookie, CookieOrigin origin) {
        boolean match;
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        String targetpath = origin.getPath();
        String topmostPath = cookie.getPath();
        if (topmostPath == null) {
            topmostPath = "/";
        }
        if (topmostPath.length() > 1 && topmostPath.endsWith("/")) {
            topmostPath = topmostPath.substring(0, topmostPath.length() - 1);
        }
        if ((match = targetpath.startsWith(topmostPath)) && targetpath.length() != topmostPath.length() && !topmostPath.endsWith("/")) {
            match = targetpath.charAt(topmostPath.length()) == '/';
        }
        return match;
    }
}

