/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.ots.thirdparty.org.apache.impl.execchain;

import com.aliyun.ots.thirdparty.org.apache.Header;
import com.aliyun.ots.thirdparty.org.apache.HttpException;
import com.aliyun.ots.thirdparty.org.apache.annotation.Immutable;
import com.aliyun.ots.thirdparty.org.apache.client.ServiceUnavailableRetryStrategy;
import com.aliyun.ots.thirdparty.org.apache.client.methods.CloseableHttpResponse;
import com.aliyun.ots.thirdparty.org.apache.client.methods.HttpExecutionAware;
import com.aliyun.ots.thirdparty.org.apache.client.methods.HttpRequestWrapper;
import com.aliyun.ots.thirdparty.org.apache.client.protocol.HttpClientContext;
import com.aliyun.ots.thirdparty.org.apache.conn.routing.HttpRoute;
import com.aliyun.ots.thirdparty.org.apache.impl.execchain.ClientExecChain;
import com.aliyun.ots.thirdparty.org.apache.util.Args;
import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Immutable
public class ServiceUnavailableRetryExec
implements ClientExecChain {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ClientExecChain requestExecutor;
    private final ServiceUnavailableRetryStrategy retryStrategy;

    public ServiceUnavailableRetryExec(ClientExecChain requestExecutor, ServiceUnavailableRetryStrategy retryStrategy) {
        Args.notNull(requestExecutor, "HTTP request executor");
        Args.notNull(retryStrategy, "Retry strategy");
        this.requestExecutor = requestExecutor;
        this.retryStrategy = retryStrategy;
    }

    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
        Header[] origheaders = request.getAllHeaders();
        int c = 1;
        while (true) {
            CloseableHttpResponse response = this.requestExecutor.execute(route, request, context, execAware);
            try {
                if (this.retryStrategy.retryRequest(response, c, context)) {
                    response.close();
                    long nextInterval = this.retryStrategy.getRetryInterval();
                    if (nextInterval > 0L) {
                        try {
                            this.log.trace((Object)("Wait for " + nextInterval));
                            Thread.sleep(nextInterval);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new InterruptedIOException();
                        }
                    }
                } else {
                    return response;
                }
                request.setHeaders(origheaders);
            }
            catch (RuntimeException ex) {
                response.close();
                throw ex;
            }
            ++c;
        }
    }
}

