/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.local;

import io.github.bucket4j.distributed.serialization.DataOutputSerializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationHandle;
import io.github.bucket4j.distributed.versioning.Versions;
import io.github.bucket4j.local.LocalBucket;
import io.github.bucket4j.local.LockFreeBucket;
import io.github.bucket4j.local.SynchronizedBucket;
import io.github.bucket4j.local.ThreadUnsafeBucket;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;

public class LocalBucketSerializationHelper {
    private static final DataOutputSerializationAdapter adapter = DataOutputSerializationAdapter.INSTANCE;

    static byte[] toBinarySnapshot(LocalBucket localBucket) throws IOException {
        SerializationHandle<LocalBucket> serializationHandle = LocalBucketSerializationHelper.getSerializationHandle(localBucket);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(baos);
        adapter.writeInt(output, serializationHandle.getTypeId());
        serializationHandle.serialize(adapter, output, localBucket, Versions.getLatest());
        return baos.toByteArray();
    }

    static LocalBucket fromBinarySnapshot(byte[] snapshot) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(snapshot);
        DataInputStream input = new DataInputStream(bais);
        int typeId = adapter.readInt(input);
        SerializationHandle<LocalBucket> serializationHandle = LocalBucketSerializationHelper.getSerializationHandle(typeId);
        return serializationHandle.deserialize(adapter, input, Versions.getLatest());
    }

    static Map<String, Object> toJsonCompatibleSnapshot(LocalBucket bucket) throws IOException {
        SerializationHandle<LocalBucket> serializationHandle = LocalBucketSerializationHelper.getSerializationHandle(bucket);
        Map<String, Object> jsonMap = serializationHandle.toJsonCompatibleSnapshot(bucket, Versions.getLatest());
        jsonMap.put("type", serializationHandle.getTypeName());
        return jsonMap;
    }

    static LocalBucket fromJsonCompatibleSnapshot(Map<String, Object> snapshot) throws IOException {
        String typeName = (String)snapshot.get("type");
        SerializationHandle<LocalBucket> serializationHandle = LocalBucketSerializationHelper.getSerializationHandle(typeName);
        return serializationHandle.fromJsonCompatibleSnapshot(snapshot, Versions.getLatest());
    }

    private static SerializationHandle<LocalBucket> getSerializationHandle(LocalBucket localBucket) throws IOException {
        switch (localBucket.getSynchronizationStrategy()) {
            case LOCK_FREE: {
                return LockFreeBucket.SERIALIZATION_HANDLE;
            }
            case SYNCHRONIZED: {
                return SynchronizedBucket.SERIALIZATION_HANDLE;
            }
            case NONE: {
                return ThreadUnsafeBucket.SERIALIZATION_HANDLE;
            }
        }
        throw new IOException("Unknown SynchronizationStrategy:" + localBucket.getSynchronizationStrategy());
    }

    private static SerializationHandle<LocalBucket> getSerializationHandle(int typeId) throws IOException {
        if (typeId == LockFreeBucket.SERIALIZATION_HANDLE.getTypeId()) {
            return LockFreeBucket.SERIALIZATION_HANDLE;
        }
        if (typeId == SynchronizedBucket.SERIALIZATION_HANDLE.getTypeId()) {
            return SynchronizedBucket.SERIALIZATION_HANDLE;
        }
        if (typeId == ThreadUnsafeBucket.SERIALIZATION_HANDLE.getTypeId()) {
            return ThreadUnsafeBucket.SERIALIZATION_HANDLE;
        }
        throw new IOException("Unknown typeId=" + typeId);
    }

    private static SerializationHandle<LocalBucket> getSerializationHandle(String typeName) throws IOException {
        if (LockFreeBucket.SERIALIZATION_HANDLE.getTypeName().equals(typeName)) {
            return LockFreeBucket.SERIALIZATION_HANDLE;
        }
        if (SynchronizedBucket.SERIALIZATION_HANDLE.getTypeName().equals(typeName)) {
            return SynchronizedBucket.SERIALIZATION_HANDLE;
        }
        if (ThreadUnsafeBucket.SERIALIZATION_HANDLE.getTypeName().equals(typeName)) {
            return ThreadUnsafeBucket.SERIALIZATION_HANDLE;
        }
        throw new IOException("Unknown typeName=" + typeName);
    }
}

