package com.bxm.abtest.facade.enums;

import org.springframework.util.StringUtils;

/**
 * @author 拉拉
 * @version v1.0.0
 * @created 2020-10-22 13:49:00
 */
public enum AlgorithmNameEnum {

    ALGORITHM_TICKET_ONE("10001", "DNNAdjust", "互动广告出券算法"),
    ALGORITHM_TICKET_TWO("10002", "DeepFMAdjust", "互动广告出券算法"),
    ALGORITHM_TICKET_THREE("10003", "fmOcpcAdjust", "互动广告出券算法"),
    ALGORITHM_TICKET_SIX("10006", "DINAdjust", "互动广告出券算法"),

    ALGORITHM_TICKET_SERVEN("10007", "VideoDNNAdjust", "互动广告视频出券算法"),
    ALGORITHM_TICKET_EIGHT("10008", "DefaultAlgorithm", "互动广告视频出券算法"),
    ALGORITHM_TICKET_NINE("10009", "VideoDINAdjust", "互动广告视频出券算法"),

    ALGORITHM_TICKET_TEN("10010", "notColdStart", "互动广告视频出券算法"),
    ALGORITHM_TICKET_ELEVEN("10011", "coldStart", "互动广告视频出券算法"),

    ALGORITHM_TICKET_TWELVE("10012", "CVRAlgorithm", "互动广告CVR出券算法"),
    ALGORITHM_TICKET_TWIRTEEN("10013", "notCVR", "互动广告CVR出券算法"),
    ALGORITHM_TICKET_FOURTEEN("10014", "PCTCVRAlgorithm", "互动广告CVR出券算法"),

    ALGORITHM_SDK_ASSETS_ONE("10004", "A1", "SDK入口素材算法"),
    ALGORITHM_SDK_ASSETS_TWO("10005", "B", "SDK入口素材算法");

    private String algorithmCode;

    private String name;

    private String desc;


    AlgorithmNameEnum(String algorithmCode, String name, String desc) {
        this.algorithmCode = algorithmCode;
        this.desc = desc;
        this.name = name;
    }

    public String getAlgorithmCode() {
        return algorithmCode;
    }

    public String getDesc() {
        return desc;
    }

    public String getName() {
        return name;
    }

    public static AlgorithmNameEnum findNameByAlgorithmCode(String algorithmCode) {
        for (AlgorithmNameEnum r : values()) {
            if (StringUtils.endsWithIgnoreCase(algorithmCode,r.algorithmCode)) {
                return r;
            }
        }
        return null;
    }
}
