package com.bxm.abtest.facade.enums;

import org.springframework.util.StringUtils;

/**
 * @author 拉拉
 * @version v1.0.0
 * @created 2020-10-22 13:49:00
 */
public enum AlgorithmNameEnum {

    ALGORITHM_TICKET_ONE("10001", "DNNAdjust", "互动广告出券算法"),
    ALGORITHM_TICKET_TWO("10002", "DeepFMAdjust", "互动广告出券算法"),
    ALGORITHM_TICKET_THREE("10003", "fmOcpcAdjust", "互动广告出券算法"),
    ALGORITHM_TICKET_TWENTY_EIGHT("10028", "DINAssets", "互动广告出券算法"),

    ALGORITHM_TICKET_SIX("10006", "DINAdjust", "互动广告CTR出券算法"),
    ALGORITHM_TICKET_TWENTY_THREE("10023", "DINCalibration", "互动CTR广告出券算法"),

    ALGORITHM_TICKET_TEN("10010", "notColdStart", "不走冷启动"),
    ALGORITHM_TICKET_ELEVEN("10011", "coldStart", "冷启动"),


    ALGORITHM_TICKET_TWIRTEEN("10013", "CVR1CPC", "互动广告CVR出券算法（OCPC一阶段出券算法）"),
    ALGORITHM_TICKET_FIFETEEN("10015", "CVR1OCPC", "互动广告CVR出券算法（OCPC一阶段出券算法）"),

    ALGORITHM_TICKET_TWELVE("10012", "CVR1", "互动广告CVR出券算法"),
    ALGORITHM_TICKET_SIXTEEN("10016", "CVR2", "互动广告CVR出券算法"),

    ALGORITHM_TICKET_TWENTY_SIX("10026", "CPC", "互动广告CVR出券算法(CPC出券算法)"),
    ALGORITHM_TICKET_TWENTY_SENVEN("10027", "CVRCPCOCPC", "互动广告CVR出券算法(CPC出券算法)"),

    ALGORITHM_TICKET_ASSETS_TWO("10021", "oldAssets", "互动广告老的算法"),
    ALGORITHM_TICKET_ASSETS_ONE("10022", "CVRAssets", "互动广告CVR素材算法"),

    ALGORITHM_SDK_ASSETS_ONE("10004", "A1", "SDK入口素材算法"),
    ALGORITHM_SDK_ASSETS_TWO("10005", "B", "SDK入口素材算法"),

    //百度相关模型
    ALGORITHM_TICKET_SERVEN("10007", "baiduCtr1", "百度ctr出券算法"),
    ALGORITHM_TICKET_EIGHT("10008", "baiduCtr2", "百度ctr出券算法"),

    ALGORITHM_TICKET_NINE("10009", "baiduCvr1", "百度cvr出券算法"),
    ALGORITHM_TICKET_FOURTEEN("10014", "baiduCvr2", "百度cvr出券算法"),

    BAIDU_ASSETS_ONE("10024", "baiduAssets1", "百度assets出券算法"),
    BAIDU_ASSETS_TWO("10025", "baiduAssets2", "百度assets出券算法"),


    //活动相关模型

    ACTIVITY_NOT_ALGO("10029", "actNotAlgo", "不走活动算法"),
    ACTIVITY_ALGO("10030", "actAlgo", "走活动算法"),

    ACTIVITY_NOT_COLD("10031", "actNotColdStart", "不走冷启动"),
    ACTIVITY_COLD("10032", "actColdStart", "冷启动"),

    ACTIVITY_CVR_ONE("10033", "actCvr1", "活动cvr1算法"),
    ACTIVITY_SEND_TICKET_COUNT_ONE("10034", "actSendTicketCount1", "活动预估发券数量算法1"),



    HEAD_TICKET_PEOPLE("10035", "people", "人工指定"),
    HEAD_TICKET_ALGO("10036", "algo", "算法"),

    HEAD_TICKET_COLDSTART("10037", "headColdstart", "头部券冷启动"),
    HEAD_TICKET_NOT_COLDSTART("10038", "headNotColdstart", "头部券不走冷启动"),

    HEAD_TICKET_BETA("10039", "headBeta", "头部券beta"),
    HEAD_TICKET_BETA1("10040", "headBeta1", "头部券beta1"),


    TICKET_SEQUENCE_FIRSTER("10041", "one", "首次发券"),
    TICKET_SEQUENCE_OTHER("10042", "other", "非首次发券"),

    HEAD_TICKET_MORE("10043", "more", "头部券多参数"),
    HEAD_TICKET_ONE("10044", "one", "头部券单参数"),


    DIRECT_ALPHA_A("10045", "a", "直投alpa值a"),
    DIRECT_ALPHA_B("10046", "b", "直投alpa值b"),

    DIRECT_COLDSTART("10047", "coldstart", "直投冷启动"),
    DIRECT_NOT_COLDSTART("10048", "notColdstart", "直投不走冷启动"),

    DIRECT_JZ_A("10049", "a", "直投校准a"),
    DIRECT_JZ_B("10050", "b", "直投校准b"),

    DIRECT_MODLE_A("10051", "a", "直投模型A"),
    DIRECT_MODLE_B("10052", "b", "直投模型B"),

    ;

    private String algorithmCode;

    private String name;

    private String desc;


    AlgorithmNameEnum(String algorithmCode, String name, String desc) {
        this.algorithmCode = algorithmCode;
        this.desc = desc;
        this.name = name;
    }

    public String getAlgorithmCode() {
        return algorithmCode;
    }

    public String getDesc() {
        return desc;
    }

    public String getName() {
        return name;
    }

    public static AlgorithmNameEnum findNameByAlgorithmCode(String algorithmCode) {
        for (AlgorithmNameEnum r : values()) {
            if (StringUtils.endsWithIgnoreCase(algorithmCode, r.algorithmCode)) {
                return r;
            }
        }
        return null;
    }
}
