/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.acl.facade;

import java.util.List;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.bxm.acl.model.ro.AuthorRo;
import com.bxm.acl.model.vo.VueMenuVo;
import com.bxm.util.dto.ResultModel;

/**
 * @ClassName AclAuthorService.java
 * @Description 功能描述：用户权限接口
 * @author leon 2018年4月13日 下午4:31:01
 * @CopyRight 杭州微财网络科技有限公司
 */
@FeignClient(name = "acl")
public interface AclAuthorService {

    /**
     * @Description 方法描述：根据用户id和系统id查询菜单
     * @author leon 2018年4月25日 下午7:54:53
     * @CopyRight 杭州微财网络科技有限公司
     * @param systemId
     * @param userId
     * @return
     */
    @RequestMapping(value = "/author/getMenuTreeList", method = RequestMethod.GET)
    public ResultModel<List<AuthorRo>> getMenuTreeList(@RequestParam(value = "systemId", required = true) Integer systemId,
                                                       @RequestParam(value = "userId", required = true) Integer userId);

    /**
     * @Description 方法描述： 根据用户id和系统id查询菜单（VUE）
     * @author leon 2017年9月6日 下午7:06:32
     * @CopyRight 杭州微财网络科技有限公司
     * @param systemId 系统id
     * @param userId 用户id
     * @return
     */
    @RequestMapping(value = "/author/getVueMenuTreeList", method = RequestMethod.GET)
    public ResultModel<List<VueMenuVo>> getVueMenuTreeList(@RequestParam(value = "systemId", required = true) Integer systemId,
                                                           @RequestParam(value = "userId", required = true) Integer userId);

    /**
     * @Description 方法描述： 查询用户是否拥有某个权限
     * @author leon 2017年9月6日 下午7:07:38
     * @CopyRight 杭州微财网络科技有限公司
     * @param systemId 系统id
     * @param userId 用户id
     * @param urlAddress url地址
     * @return
     */
    @RequestMapping(value = "/author/isHasAuthor", method = RequestMethod.GET)
    public ResultModel<Boolean> isHasAuthor(@RequestParam(value = "systemId", required = true) Integer systemId,
                                            @RequestParam(value = "userId", required = true) Integer userId,
                                            @RequestParam(value = "urlAddress", required = true) String urlAddress);
}
