/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.acl.facade;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.bxm.acl.model.ro.UserRo;
import com.bxm.util.dto.ResultModel;

/**
 * @ClassName AclAuthorService.java
 * @Description 功能描述：用户权限接口
 * @author leon 2018年4月13日 下午4:31:01
 * @CopyRight 杭州微财网络科技有限公司
 */
@FeignClient(name = "acl")
public interface AclUserService {

    /**
     * @Description 方法描述： 根据id查询数据
     * @author leon 2017年9月5日 下午7:35:07
     * @CopyRight 杭州微财网络科技有限公司
     * @param id
     * @return
     */
    @RequestMapping(value = "/user/getById", method = RequestMethod.GET)
    public ResultModel<UserRo> getById(@RequestParam(value = "id", required = true) Integer id);

    /**
     * @Description 方法描述： 登录
     * @author leon 2017年9月5日 下午7:21:30
     * @CopyRight 杭州微财网络科技有限公司
     * @param request
     * @return
     */
    @RequestMapping(value = "/user/login", method = { RequestMethod.POST })
    public ResultModel<UserRo> login(@RequestParam(value = "username", required = true) String username,
                                     @RequestParam(value = "password", required = true) String password);

    /**
     * @Description 方法描述： 根据token查询用户
     * @author leon 2017年10月22日 下午2:14:23
     * @CopyRight 杭州微财网络科技有限公司
     * @param token
     * @return
     */
    @RequestMapping(value = "/user/getByToken", method = { RequestMethod.GET })
    public ResultModel<UserRo> getUserByToken(@RequestParam(value = "token", required = true) String token);

}
