package com.bxm.activities.model.gametemplate;

import java.io.Serializable;

/**
 * 游戏模板
 * @author zhengwangeng
 * @since 2021-12-22
 */
public class GameTemplateFacadeVO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 类型
     * 1、提现类
     * 2、实物类
     * 3、积分打通
     */
    public static final short TYPE_MONEY = 1;
    public static final short TYPE_OBJECT = 2;
    public static final short TYPE_INTEGRAL = 3;

    /**
     * 周期
     * 1、7天=周
     * 2、30天=月
     * 3、永久
     */
    public static final short CYCLE_WEEK = 1;
    public static final short CYCLE_MONTH = 2;
    public static final short CYCLE_FOREVER = 3;

    /**
     * 1、未开启状态：皆可修改
     * 2、开启状态：可修改游戏名称/游戏类型/游戏周期，游戏状态可修改为停用状态，不可修改基础配置和发奖参数
     * 3、停用状态：可修改游戏名称/游戏类型/游戏周期，游戏状态可修改为启用状态，不可修改基础配置和发奖参数
     */
    public static final short STATUS_UN_OPENED = 1;
    public static final short STATUS_OPEN = 2;
    public static final short STATUS_STOP = 3;

    /**
     * ID
     */
    private Long id;

    /**
     * 代号
     */
    private String code;

    /**
     * 名称
     */
    private String name;

    /**
     * 类型
     */
    private Short type;

    /**
     * 周期
     */
    private Short cycle;

    /**
     * 状态
     */
    private Short status;

    /**
     * 媒介运营
     */
    private String mjCode;

    /**
     * 具体配置Json
     */
    private String jsonConfig;

    /**
     * 创建人
     */
    private String createUser;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code == null ? null : code.trim();
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    public Short getType() {
        return type;
    }

    public void setType(Short type) {
        this.type = type;
    }

    public Short getCycle() {
        return cycle;
    }

    public void setCycle(Short cycle) {
        this.cycle = cycle;
    }

    public Short getStatus() {
        return status;
    }

    public void setStatus(Short status) {
        this.status = status;
    }

    public String getMjCode() {
        return mjCode;
    }

    public void setMjCode(String mjCode) {
        this.mjCode = mjCode;
    }

    public String getJsonConfig() {
        return jsonConfig;
    }

    public void setJsonConfig(String jsonConfig) {
        this.jsonConfig = jsonConfig == null ? null : jsonConfig.trim();
    }

    public String getCreateUser() {
        return createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser == null ? null : createUser.trim();
    }
}