package com.bxm.activities.service;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.bxm.activities.model.gametemplate.GameTemplateFacadeSearchDTO;
import com.bxm.activities.model.gametemplate.GameTemplateFacadeVO;
import com.bxm.warcar.utils.response.ResultModel;
import com.github.pagehelper.PageInfo;

/**
 * 游戏模板 facade 服务
 * @author zhengwangeng
 * @since 2021-12-22
 */
@FeignClient("ACTIVITIES-MANAGER")
public interface GameTemplateFacadeService {

    @RequestMapping(value = "/facade/gameTemplate/findPage", method = RequestMethod.POST)
    ResultModel<PageInfo<GameTemplateFacadeVO>> finPage(@RequestBody GameTemplateFacadeSearchDTO dto);

    @RequestMapping(value = "/facade/gameTemplate/get", method = RequestMethod.GET)
    ResultModel<GameTemplateFacadeVO> get(@RequestParam(name = "id" ) Long id);
}
