package com.bxm.activites.facade.model;

import com.bxm.activites.facade.model.souhu.SouhuActivityRequestDto;
import com.bxm.warcar.validate.annotation.DefaultValue;
import com.bxm.warcar.validate.annotation.ValidateImeiOrIdfa;
import com.bxm.warcar.validate.annotation.ValidateNotNull;

import java.io.Serializable;

/**
 * <p> 活动接口参数类 </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2018/8/13
 */
public class ActivityRedirectDto  extends SouhuActivityRequestDto implements Serializable{
    private static final long serialVersionUID = 3901216412047397258L;

    /**
     * ip地址
     */
    private String ipAddress;
    /**
     * 流水号
     */
    private String spm;
    /**
     * 开发者唯一标识
     */
    private String appKey;
    /**
     * 渠道类型
     */
    private String business;
    /**
     * imei
     */
    @ValidateImeiOrIdfa
    private String i;
    /**
     * idfn
     */
    @ValidateImeiOrIdfa
    private String f;
    /**
     * 子渠道
     */
    @ValidateNotNull
    @DefaultValue("1")
    private String appEntrance;
    /**
     * 活动ID
     */
    private String activityid;
    /**
     * 请求域名
     */
    private String origin;
    /**
     * 用户token
     */
    private String uid;

    /**
     * 数据新埋点需要userAgent参数
     */
    private String userAgent;

    /**
     * 数据新埋点需要referer参数
     */
    private String referer;

    /**
     * 应用
     * 0 未知
     * 1 微信
     * 2 支付宝
     */
    private int app = 0;

    public String getIpAddress() {
        return ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getSpm() {
        return spm;
    }

    public void setSpm(String spm) {
        this.spm = spm;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getBusiness() {
        return business;
    }

    public void setBusiness(String business) {
        this.business = business;
    }

    public String getI() {
        return i;
    }

    public void setI(String i) {
        this.i = i;
    }

    public String getF() {
        return f;
    }

    public void setF(String f) {
        this.f = f;
    }

    public String getAppEntrance() {
        return appEntrance;
    }

    public void setAppEntrance(String appEntrance) {
        this.appEntrance = appEntrance;
    }

    public String getActivityid() {
        return activityid;
    }

    public void setActivityid(String activityid) {
        this.activityid = activityid;
    }

    public String getOrigin() {
        return origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public String getUserAgent() {
        return userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getReferer() {
        return referer;
    }

    public void setReferer(String referer) {
        this.referer = referer;
    }

    public int getApp() {
        return app;
    }

    public void setApp(int app) {
        this.app = app;
    }

    @Override
    public String toString() {
        return "ActivityRedirectDto{" +
                "ipAddress='" + ipAddress + '\'' +
                ", spm='" + spm + '\'' +
                ", appKey='" + appKey + '\'' +
                ", business='" + business + '\'' +
                ", i='" + i + '\'' +
                ", f='" + f + '\'' +
                ", appEntrance='" + appEntrance + '\'' +
                ", activityid='" + activityid + '\'' +
                ", origin='" + origin + '\'' +
                ", uid='" + uid + '\'' +
                ", userAgent='" + userAgent + '\'' +
                ", referer='" + referer + '\'' +
                ", app=" + app +
                '}';
    }
}
