package com.bxm.activites.facade.model;

import com.bxm.warcar.validate.annotation.DefaultValue;
import com.bxm.warcar.validate.annotation.ValidateImeiOrIdfa;
import com.bxm.warcar.validate.annotation.ValidateLength;
import com.bxm.warcar.validate.annotation.ValidateNotNull;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

/**
 * 弹窗数据请求对象
 *
 * @ClassName PopupDto
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/8/8 11:44
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/8/8 11:44
 **/
public class PopupAwardDto implements Serializable{

    private static final long serialVersionUID = 6116479035584826526L;

    /**
     *  弹窗类型  0-出券弹窗 1-首页弹窗 2-挽留弹窗
     */
    @DefaultValue("0")
    @ValidateNotNull
    private Integer scene;

    /**
     * 媒体
     */
    @DefaultValue("mistake_appKey")
    @ValidateLength(min = 32, max = 32)
    private String appkey;

    /**
     * 渠道
     */
    @DefaultValue("mistake_biz")
    @ValidateNotNull
    public String business;

    /**
     * 渠道
     */
    @DefaultValue("1")
    @ValidateNotNull
    private Integer appEntrance;

    /**
     * 用户ID
     */
    @DefaultValue("mistake_uid")
    @ValidateNotNull
    private String uid;

    /**
     * IMEI 安卓唯一标识码
     */
    @ValidateImeiOrIdfa
    private String i;

    /**
     * IDFA 苹果唯一标识符
     */
    @ValidateImeiOrIdfa
    private String f;

    /**
     * 活动ID
     */
    @DefaultValue("0")
    @ValidateNotNull
    private Integer activityid;

    /**
     * 设备类型（1-安卓 2-ios 3-web）
     */
    @DefaultValue("1")
    @ValidateNotNull
    private String appos;

    /**
     * 是否是微信（1是0否）
     */
    @DefaultValue("0")
    @ValidateNotNull
    private Integer ua;

    /**
     * 是否为小程序端（1是0否）
     */
    @DefaultValue("0")
    @ValidateNotNull
    private String device;

    /**
     * 请求ip地址
     */
    private String ipaddress;

    /**
     * 弹窗类型  0--出券弹窗  1--首张弹窗  2--挽留弹窗
     */
    @DefaultValue("1")
    @ValidateNotNull
    public Integer popupType;

    public String getPositionId() {
        return StringUtils.join(new Object []{appkey, business.replaceAll("ad-|money-", "")}, "-");
    }

    public Integer getScene() {
        return scene;
    }

    public void setScene(Integer scene) {
        this.scene = scene;
    }

    public String getAppkey() {
        return appkey;
    }

    public void setAppkey(String appkey) {
        this.appkey = appkey;
    }

    public String getBusiness() {
        return business;
    }

    public void setBusiness(String business) {
        this.business = business;
    }

    public Integer getAppEntrance() {
        return appEntrance;
    }

    public void setAppEntrance(Integer appEntrance) {
        this.appEntrance = appEntrance;
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getI() {
        return i;
    }

    public void setI(String i) {
        this.i = i;
    }

    public String getF() {
        return f;
    }

    public void setF(String f) {
        this.f = f;
    }

    public Integer getActivityid() {
        return activityid;
    }

    public void setActivityid(Integer activityid) {
        this.activityid = activityid;
    }

    public String getAppos() {
        return appos;
    }

    public void setAppos(String appos) {
        this.appos = appos;
    }

    public Integer getUa() {
        return ua;
    }

    public void setUa(Integer ua) {
        this.ua = ua;
    }

    public String getDevice() {
        return device;
    }

    public void setDevice(String device) {
        this.device = device;
    }

    public String getIpaddress() {
        return ipaddress;
    }

    public void setIpaddress(String ipaddress) {
        this.ipaddress = ipaddress;
    }

    public Integer getPopupType() {
        return popupType;
    }

    public void setPopupType(Integer popupType) {
        this.popupType = popupType;
    }
}
