package com.bxm.activites.facade.service;


import com.bxm.activites.facade.constant.Constants;
import com.bxm.activites.facade.model.ActivityRedirectDto;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * <p> 活动中间页 service </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2018/8/14
 */
@FeignClient(name = Constants.SERVER_NAME)
public interface ActivityRedirectService {

    /**
     * 获取活动信息，并返回活动链接
     * @param activityInfo
     * @return
     */
    @RequestMapping(value = "/activityRedirectService/getActivityUrl", method = RequestMethod.POST)
    String getActivityUrl(@RequestBody ActivityRedirectDto activityInfo);

    /**
     * 获取特殊url
     * @param activityInfo
     * @return
     */
    @RequestMapping(value = "/activityRedirectService/getSpecialUrl", method = RequestMethod.POST)
    String getSpecialUrl(@RequestBody ActivityRedirectDto activityInfo);

    /**
     * 获取广告位是否关闭
     * @param   appKey,  appEntrance
     * @return
     */
    @RequestMapping(value = "/activityRedirectService/getPositionStatusSwitch", method = RequestMethod.POST)
    Boolean getPositionStatusSwitch(@RequestParam("appKey") String appKey, @RequestParam("appEntrance") String appEntrance);

}
