package com.bxm.activites.facade.service;


import com.bxm.activites.facade.constant.Constants;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.Set;

/**
 * 用户相关服务
 * @author allen
 * @since 1.0.0
 */
@FeignClient(name = Constants.SERVER_NAME)
public interface UserService {


    /**  
	 * @Title: getUserActRecord  
	 * @Description:  获取用户活动参与记录
	 * @author xavier  
	 * @date 2018年5月9日
	 */
    @RequestMapping("/userService/getUserActRecord")
	public Set<Long> getUserActRecord(@RequestParam(value = "uid") String uid);
	
	/**  
	 * @Title: saveUserActRecord  
	 * @Description:  保存用户活动参与信息
	 * @author xavier  
	 * @date 2018年5月9日
	 */
	@RequestMapping(value = "/userService/saveUserActRecord/{uid}", method = RequestMethod.POST)
	public void saveUserActRecord(@PathVariable("uid") String uid,
								  @RequestBody Set<Long> record);
	
}
