package com.bxm.activites.facade.service;

import com.bxm.activites.facade.constant.Constants;
import com.bxm.activites.facade.model.venue.vo.VenueapiReturnVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 主会场相关服务
 * @author bcc
 * @date 2018/08/31
 */
@FeignClient(name = Constants.SERVER_NAME)
public interface VenueapiService {

    /**
     * 根据广告位ID获取，主会场及浮标素材信息
     * @param positionId
     * @return
     */
    @RequestMapping("/venueapiService/getByPositionId")
    VenueapiReturnVo getByPositionId(@RequestParam(value = "positionId") String positionId);

}
