/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.acl.facade;

import com.alibaba.fastjson.JSONObject;
import com.bxm.acl.facade.model.ResultModel;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class Utils {
    public static final String COOKIE_LOGIN_KEY = "token";

    public static String getToken(HttpServletRequest request) {
        String token = request.getHeader(COOKIE_LOGIN_KEY);
        if (token == null) {
            token = request.getParameter(COOKIE_LOGIN_KEY);
        }
        return token;
    }

    public static void sendErrorMsg(HttpServletResponse response, String errorMsg, String errorCode) throws IOException {
        ResultModel result = new ResultModel();
        result.setSuccessed(false);
        result.setErrorDesc(errorMsg);
        result.setErrorCode(errorCode);
        response.setContentType("application/json;charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        PrintWriter out = response.getWriter();
        String json = JSONObject.toJSONString(result);
        out.print(json);
        out.flush();
    }

    public static String getIp(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (StringUtils.isNotEmpty((String)ip) && !"unKnown".equalsIgnoreCase(ip)) {
            int index = ip.indexOf(",");
            if (index != -1) {
                return ip.substring(0, index);
            }
            return ip;
        }
        ip = request.getHeader("X-Real-IP");
        if (StringUtils.isNotEmpty((String)ip) && !"unKnown".equalsIgnoreCase(ip)) {
            return ip;
        }
        ip = request.getHeader("Proxy-Client-IP");
        if (ip != null && !ip.isEmpty() && !"unKnown".equalsIgnoreCase(ip)) {
            return ip;
        }
        ip = request.getHeader("WL-Proxy-Client-IP");
        if (ip != null && !ip.isEmpty() && !"unKnown".equalsIgnoreCase(ip)) {
            return ip;
        }
        ip = request.getRemoteAddr();
        return ip.equals("0:0:0:0:0:0:0:1") ? "127.0.0.1" : ip;
    }
}

