/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adapi.integration.xunfei;

import com.alibaba.fastjson.JSON;
import com.bxm.adapi.integration.xunfei.Creative;
import com.bxm.adapi.integration.xunfei.CreativeDto;
import com.bxm.adapi.integration.xunfei.DingtalkMsgService;
import com.bxm.adapi.integration.xunfei.GetTokenResultVo;
import com.bxm.adapi.integration.xunfei.InputTypeEnum;
import com.bxm.adapi.integration.xunfei.OkHttpUtils;
import com.bxm.adapi.integration.xunfei.XunfeiResultVo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UpdateXunfeiCreative {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateXunfeiCreative.class);
    @Resource
    private DingtalkMsgService dingtalkMsgService;

    private String getAccessToken(String appId, String appKey, String domain) throws IOException {
        GetTokenResultVo getTokenResultVo;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("appId", appId);
        params.put("appKey", appKey);
        String resultStr = OkHttpUtils.post(domain + "/bxm/login/token", params, null);
        if (StringUtils.isNotBlank((String)resultStr) && (getTokenResultVo = (GetTokenResultVo)JSON.parseObject((String)resultStr, GetTokenResultVo.class)).getStatus() == 11) {
            return getTokenResultVo.getData().getAccessToken();
        }
        return null;
    }

    public void update(String appId, String appKey, String domain, String imgUrl, String adPositionId, long adPositionMaterialId, long mediaAdPositionId) {
        String resultStr = "";
        try {
            XunfeiResultVo xunfeiResultVo;
            CreativeDto creativeDto = new CreativeDto();
            ArrayList<Creative> creatives = new ArrayList<Creative>();
            Creative creative = new Creative();
            creative.setContent(imgUrl);
            creative.setInputType(InputTypeEnum.PICTURE.getCode());
            creatives.add(creative);
            creativeDto.setAdPositionId(adPositionId);
            creativeDto.setAdPositionMaterialId(adPositionMaterialId);
            creativeDto.setMediaAdPositionId(mediaAdPositionId);
            String[] adPositionIdStrs = adPositionId.split("-");
            creativeDto.setBxmUrl("http://m.cudaojia.com?appKey=" + adPositionIdStrs[0] + "&appType=app&appEntrance=" + adPositionIdStrs[1] + "&business=money");
            creativeDto.setCreative(creatives);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Access-Token", this.getAccessToken(appId, appKey, domain));
            resultStr = OkHttpUtils.post(domain + "/bxm/creative/update", JSON.toJSONString((Object)creativeDto), headers);
            if (StringUtils.isNotBlank((String)resultStr) && (xunfeiResultVo = (XunfeiResultVo)JSON.parseObject((String)resultStr, XunfeiResultVo.class)).getStatus() != 11) {
                StringBuilder msg = new StringBuilder("\u66ff\u6362\u8baf\u98de\u5e7f\u544a\u4f4d\u7d20\u6750\u51fa\u9519\uff1a" + xunfeiResultVo.getMsg());
                if (StringUtils.equals((String)xunfeiResultVo.getMsg(), (String)"\u8be5\u843d\u5730\u9875\u65e0\u6548\uff0c\u8bf7\u8054\u7cfb\u8fd0\u8425")) {
                    msg.append("\uff0c\u6b64\u5e7f\u544a\u4f4d\u8baf\u98de\u672a\u914d\u7f6e\u6216\u5df2\u4e0b\u7ebf\uff0c\u8bf7\u5148\u5173\u95ed\u8be5\u5e7f\u544a\u4f4d\u76f8\u5173\u7d20\u6750\u6216\u8005\u8054\u7cfb\u8baf\u98de\u8fd0\u8425\u5c3d\u5feb\u914d\u7f6e\uff0c\u5e7f\u544a\u4f4did\uff1a").append(adPositionId).append(",\u7d20\u6750id\uff1a").append(adPositionMaterialId);
                } else if (StringUtils.equals((String)xunfeiResultVo.getMsg(), (String)"\u7d20\u6750\u683c\u5f0f\u4e0d\u7b26\u5408")) {
                    msg.append("\uff0c\u6b64\u5e7f\u544a\u4f4d\u7d20\u6750\u5c3a\u5bf8\u4e0d\u7b26\u5408\u8baf\u98de\u8981\u6c42\uff0c\u8bf7\u5c3d\u5feb\u8054\u7cfb\u76f8\u5173\u8fd0\u8425\u5e76\u4fee\u6539\uff0c\u5e7f\u544a\u4f4did\uff1a").append(adPositionId).append(",\u7d20\u6750id\uff1a").append(adPositionMaterialId);
                } else {
                    msg.append("\uff0c\u5e7f\u544a\u4f4did\uff1a").append(adPositionId).append(",\u7d20\u6750id\uff1a").append(adPositionMaterialId);
                }
                this.dingtalkMsgService.sendMsg(msg.toString(), false);
            }
        }
        catch (Exception e) {
            String msg = "\u66ff\u6362\u8baf\u98de\u5e7f\u544a\u4f4d\u7d20\u6750\u51fa\u9519,\u8c03\u7528\u8baf\u98de\u63a5\u53e3:" + domain + "/bxm/creative/update" + "\uff0c\u51fa\u73b0\u9519\u8bef\u5f02\u5e38";
            this.dingtalkMsgService.sendErrorMsg(msg, false, e);
            LOGGER.error("\u66ff\u6362\u8baf\u98de\u5e7f\u544a\u4f4d\u7d20\u6750\u51fa\u9519,resultStr={}:", (Object)resultStr, (Object)e);
        }
    }
}

