/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adapi.commons;

import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class ConsumeTimeMetrics {
    private final ConcurrentMap<String, AtomicLong> lastTaskConsumeTimeTable = new ConcurrentHashMap<String, AtomicLong>();
    private final ConcurrentMap<String, AtomicLong> largestTaskConsumeTimeTable = new ConcurrentHashMap<String, AtomicLong>();
    private final ConcurrentMap<String, TreeMap<Integer, AtomicLong>> sectionTaskConsumeTimeTable = new ConcurrentHashMap<String, TreeMap<Integer, AtomicLong>>();

    public void increaseTask(String serviceName, long consumingTime) {
        AtomicLong largestTimeContainer;
        AtomicLong lastTaskConsumeTime = this.lastTaskConsumeTimeTable.putIfAbsent(serviceName, new AtomicLong(0L));
        if (null == lastTaskConsumeTime) {
            lastTaskConsumeTime = (AtomicLong)this.lastTaskConsumeTimeTable.get(serviceName);
        }
        lastTaskConsumeTime.set(consumingTime);
        TreeMap<Integer, AtomicLong> section = this.buildSection();
        TreeMap sectionTaskConsumeTime = this.sectionTaskConsumeTimeTable.putIfAbsent(serviceName, section);
        if (null == section) {
            sectionTaskConsumeTime = (TreeMap)this.sectionTaskConsumeTimeTable.get(serviceName);
        }
        for (Map.Entry<Integer, AtomicLong> integerAtomicLongEntry : sectionTaskConsumeTime.entrySet()) {
            Integer s = integerAtomicLongEntry.getKey();
            if (consumingTime >= (long)s.intValue()) continue;
            integerAtomicLongEntry.getValue().incrementAndGet();
            break;
        }
        if (null == (largestTimeContainer = this.largestTaskConsumeTimeTable.putIfAbsent(serviceName, new AtomicLong(0L)))) {
            largestTimeContainer = (AtomicLong)this.largestTaskConsumeTimeTable.get(serviceName);
        }
        this.processLargestTaskConsumeTime(largestTimeContainer, consumingTime);
    }

    private TreeMap<Integer, AtomicLong> buildSection() {
        TreeMap<Integer, AtomicLong> section = new TreeMap<Integer, AtomicLong>();
        section.put(10, new AtomicLong(0L));
        section.put(20, new AtomicLong(0L));
        section.put(50, new AtomicLong(0L));
        section.put(100, new AtomicLong(0L));
        section.put(Integer.MAX_VALUE, new AtomicLong(0L));
        return section;
    }

    private void processLargestTaskConsumeTime(AtomicLong largestTimeContainer, long consumingTime) {
        int retry = 0;
        boolean done = false;
        do {
            long expect;
            if (consumingTime <= (expect = largestTimeContainer.longValue())) continue;
            done = largestTimeContainer.compareAndSet(expect, consumingTime);
        } while (!done && ++retry < 3);
    }

    public ConcurrentMap<String, AtomicLong> getLastTaskConsumeTimeTable() {
        return this.lastTaskConsumeTimeTable;
    }

    public ConcurrentMap<String, AtomicLong> getLargestTaskConsumeTimeTable() {
        return this.largestTaskConsumeTimeTable;
    }

    public ConcurrentMap<String, TreeMap<Integer, AtomicLong>> getSectionTaskConsumeTimeTable() {
        return this.sectionTaskConsumeTimeTable;
    }
}

