/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adapi.commons;

import com.bxm.adapi.commons.ConsumeTimeMetrics;
import com.bxm.adapi.commons.CounterMetrics;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=-99)
@Aspect
@Component
public class MetricsAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricsAspect.class);
    @Autowired
    private ConsumeTimeMetrics consumeTimeMetrics;
    @Autowired
    private CounterMetrics counterMetrics;

    @Bean
    public ConsumeTimeMetrics consumeTimeMetrics() {
        return new ConsumeTimeMetrics();
    }

    @Bean
    public CounterMetrics counterMetrics() {
        return new CounterMetrics();
    }

    public MetricsAspect() {
        new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setName("monitor");
                return thread;
            }
        }).scheduleWithFixedDelay(() -> {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("consume-section-time-metrics: \n{}", this.consumeTimeMetrics.getSectionTaskConsumeTimeTable());
                LOGGER.info("count-metrics: \n{}\n{}", this.counterMetrics.getSuccessTasks(), this.counterMetrics.getFailTasks());
            }
        }, 1L, 1L, TimeUnit.MINUTES);
    }

    @Around(value="within(@com.bxm.adapi.commons.Metrics *)")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        long start = System.currentTimeMillis();
        Object proceed = point.proceed();
        try {
            String name = this.getServiceName((JoinPoint)point);
            long consumingTime = System.currentTimeMillis() - start;
            this.consumeTimeMetrics.increaseTask(name, consumingTime);
            this.counterMetrics.incrementSuccessTask(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return proceed;
    }

    @AfterThrowing(value="within(@com.bxm.adapi.commons.Metrics *))", throwing="throwing")
    public void afterThrowing(JoinPoint point, Throwable throwing) {
        this.counterMetrics.incrementFailTask(this.getServiceName(point));
    }

    private String getServiceName(JoinPoint point) {
        return point.getSignature().toShortString();
    }
}

