/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adapi.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.bxm.adapi.config.DruidProperties;
import com.github.pagehelper.PageInterceptor;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

@Configuration
@EnableConfigurationProperties(value={DruidProperties.class})
@ConditionalOnProperty(prefix="druid", name={"url"})
@AutoConfigureBefore(value={DataSourceAutoConfiguration.class})
@MapperScan(basePackages={"com.bxm.adapi.dal.guide.mapper"}, sqlSessionFactoryRef="datasourceSqlSessionFactory")
public class DruidAutoConfiguration {
    static final String PACKAGE = "com.bxm.adapi.dal.guide.mapper";
    @Autowired
    private DruidProperties properties;

    @Bean(value={"dataSource"})
    @Primary
    @ConfigurationProperties(prefix="datasource.primary")
    public DataSource dataSource() {
        DruidDataSource dataSource = new DruidDataSource();
        dataSource.setUrl(this.properties.getUrl());
        dataSource.setUsername(this.properties.getUsername());
        dataSource.setPassword(this.properties.getPassword());
        if (this.properties.getInitialSize() > 0) {
            dataSource.setInitialSize(this.properties.getInitialSize());
        }
        if (this.properties.getMinIdle() > 0) {
            dataSource.setMinIdle(this.properties.getMinIdle());
        }
        if (this.properties.getMaxActive() > 0) {
            dataSource.setMaxActive(this.properties.getMaxActive());
        }
        dataSource.setTestOnBorrow(this.properties.isTestOnBorrow());
        try {
            dataSource.init();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return dataSource;
    }

    @Bean(name={"datasourceTransactionManager"})
    @Primary
    public DataSourceTransactionManager datasourceTransactionManager() {
        return new DataSourceTransactionManager(this.dataSource());
    }

    @Bean(name={"datasourceSqlSessionFactory"})
    @Primary
    public SqlSessionFactory datasourceSqlSessionFactory(@Qualifier(value="dataSource") DataSource dataSource) throws Exception {
        SqlSessionFactoryBean sessionFactory = new SqlSessionFactoryBean();
        sessionFactory.setDataSource(dataSource);
        sessionFactory.setMapperLocations(new PathMatchingResourcePatternResolver().getResources("classpath:sql/guide/**/*.xml"));
        PageInterceptor interceptor = new PageInterceptor();
        Properties properties = new Properties();
        properties.setProperty("helperDialect", "mysql");
        properties.setProperty("offsetAsPageNum", "true");
        properties.setProperty("rowBoundsWithCount", "true");
        properties.setProperty("reasonable", "false");
        properties.setProperty("supportMethodsArguments", "true");
        properties.setProperty("params", "pageNum=pageNumKey;pageSize=pageSizeKey;");
        interceptor.setProperties(properties);
        sessionFactory.setPlugins(new Interceptor[]{interceptor});
        return sessionFactory.getObject();
    }
}

