/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adapi.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.bxm.adapi.config.DruidProperties2;
import com.github.pagehelper.PageInterceptor;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

@Configuration
@EnableConfigurationProperties(value={DruidProperties2.class})
@ConditionalOnClass(value={DruidDataSource.class})
@ConditionalOnProperty(prefix="druid2", name={"url"})
@AutoConfigureBefore(value={DataSourceAutoConfiguration.class})
@MapperScan(basePackages={"com.bxm.adapi.dal.ad_api_material.mapper"}, sqlSessionFactoryRef="dataSource2SqlSessionFactory")
public class DruidAutoConfiguration2 {
    static final String PACKAGE = "com.bxm.adapi.dal.ad_api_material.mapper";
    @Autowired
    private DruidProperties2 properties2;

    @Bean(value={"dataSource2"})
    public DataSource dataSource2() {
        DruidDataSource dataSource2 = new DruidDataSource();
        dataSource2.setUrl(this.properties2.getUrl());
        dataSource2.setUsername(this.properties2.getUsername());
        dataSource2.setPassword(this.properties2.getPassword());
        if (this.properties2.getInitialSize() > 0) {
            dataSource2.setInitialSize(this.properties2.getInitialSize());
        }
        if (this.properties2.getMinIdle() > 0) {
            dataSource2.setMinIdle(this.properties2.getMinIdle());
        }
        if (this.properties2.getMaxActive() > 0) {
            dataSource2.setMaxActive(this.properties2.getMaxActive());
        }
        dataSource2.setTestOnBorrow(this.properties2.isTestOnBorrow());
        try {
            dataSource2.init();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return dataSource2;
    }

    @Bean(name={"dataSource2TransactionManager"})
    public DataSourceTransactionManager dataSource2TransactionManager(@Qualifier(value="dataSource2") DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }

    @Bean(name={"dataSource2SqlSessionFactory"})
    public SqlSessionFactory dataSource2SqlSessionFactory(@Qualifier(value="dataSource2") DataSource dataSource) throws Exception {
        SqlSessionFactoryBean sessionFactory = new SqlSessionFactoryBean();
        sessionFactory.setDataSource(dataSource);
        sessionFactory.setMapperLocations(new PathMatchingResourcePatternResolver().getResources("classpath:sql/ad_api_material/**/*.xml"));
        PageInterceptor interceptor = new PageInterceptor();
        Properties properties = new Properties();
        properties.setProperty("helperDialect", "mysql");
        properties.setProperty("offsetAsPageNum", "true");
        properties.setProperty("rowBoundsWithCount", "true");
        properties.setProperty("reasonable", "false");
        properties.setProperty("supportMethodsArguments", "true");
        properties.setProperty("params", "pageNum=pageNumKey;pageSize=pageSizeKey;");
        interceptor.setProperties(properties);
        sessionFactory.setPlugins(new Interceptor[]{interceptor});
        return sessionFactory.getObject();
    }
}

