/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adapi.config;

import com.bxm.util.SerializableUtil;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Component
public class RedisClient {
    @Autowired
    private JedisPool jedisPool;
    private static final int THREE_DAY_SECOND = 259200;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String key, String value) throws Exception {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            jedis.set(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getByKeys(String redisKey) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            Set keys = jedis.keys(redisKey);
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (keys != null && keys.size() > 0) {
                for (String key : keys) {
                    map.put(key, jedis.get(key));
                }
            }
            HashMap<String, Object> hashMap = map;
            return hashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delByKeys(String redisKey) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            Set keys = jedis.keys(redisKey);
            if (keys != null && keys.size() > 0) {
                for (String key : keys) {
                    jedis.del(key);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String key, int seconds, String value) throws Exception {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            jedis.setex(key, seconds, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String key) throws Exception {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            String string = jedis.get(key);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incr(String key, Integer seconds) throws Exception {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            jedis.incr(key);
            if (seconds == null) {
                int secondsLeftToday = (int)(259200L - DateUtils.getFragmentInMilliseconds((Calendar)Calendar.getInstance(), (int)5) / 1000L);
                jedis.expire(key, secondsLeftToday);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrBy(String key, Long count) throws Exception {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            jedis.incrBy(key, count.longValue());
            int secondsLeftToday = (int)(259200L - DateUtils.getFragmentInMilliseconds((Calendar)Calendar.getInstance(), (int)5) / 1000L);
            jedis.expire(key, secondsLeftToday);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(String key, Object value) throws Exception {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            jedis.set(key.getBytes(), SerializableUtil.toByteArray((Object)value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(String key, int seconds, Object value) throws Exception {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            jedis.setex(key.getBytes(), seconds, SerializableUtil.toByteArray((Object)value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(String key) throws Exception {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            byte[] obj = jedis.get(key.getBytes());
            if (obj == null) {
                Object var4_4 = null;
                return var4_4;
            }
            Object object = SerializableUtil.toObject((byte[])obj);
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delObject(String key) throws Exception {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (jedis.exists(key).booleanValue()) {
                boolean bl = jedis.del(key) > 0L;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sAdd(String key, String value, Integer seconds) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            jedis.sadd(key, new String[]{value});
            if (seconds != null) {
                jedis.expire(key, seconds.intValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> smembers(String key) {
        HashSet<String> result = new HashSet();
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            result = jedis.smembers(key);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void srem(String key, String value) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            jedis.srem(key, new String[]{value});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hset(String key, String field, String value) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            jedis.hset(key, field, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> hgetAll(String key) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            Map map = jedis.hgetAll(key);
            return map;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String hget(String key, String field) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            String string = jedis.hget(key, field);
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hdel(String key, String fields) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            boolean bl = jedis.hdel(key, new String[]{fields}) > 0L;
            return bl;
        }
        return false;
    }
}

