/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adapi.quartz;

import com.alibaba.druid.pool.DruidDataSource;
import com.bxm.adapi.quartz.AutowiringSpringBeanJobFactory;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.quartz.spi.JobFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.stereotype.Component;

@Component
public class QuartzConfigProperties {
    @Value(value="${org.quartz.scheduler.instanceName}")
    private String quartzInstanceName;
    @Value(value="${org.quartz.scheduler.instanceId}")
    private String instanceId;
    @Value(value="${org.quartz.scheduler.skipUpdateCheck}")
    private String skipUpdateCheck;
    @Value(value="${org.quartz.scheduler.jmx.export}")
    private String export;
    @Value(value="${org.quartz.threadPool.class}")
    private String threadPoolClass;
    @Value(value="${org.quartz.threadPool.threadCount}")
    private String threadCount;
    @Value(value="${org.quartz.threadPool.threadPriority}")
    private String threadPriority;
    @Value(value="${org.quartz.threadPool.threadsInheritContextClassLoaderOfInitializingThread}")
    private String threadsInheritContextClassLoaderOfInitializingThread;
    @Value(value="${org.quartz.jobStore.misfireThreshold}")
    private String misfireThreshold;
    @Value(value="${org.quartz.jobStore.class}")
    private String jobStoreClass;
    @Value(value="${org.quartz.jobStore.tablePrefix}")
    private String tablePrefix;
    @Value(value="${org.quartz.jobStore.dataSource}")
    private String dataSource;
    @Value(value="${org.quartz.jobStore.isClustered}")
    private String isClustered;
    @Value(value="${org.quartz.jobStore.clusterCheckinInterval}")
    private String clusterCheckinInterval;
    @Value(value="${org.quartz.jobStore.driverDelegateClass}")
    private String driverDelegateClass;
    @Value(value="${org.quartz.jobStore.maxMisfiresToHandleAtATime}")
    private String maxMisfiresToHandleAtATime;
    @Value(value="${org.quartz.jobStore.txIsolationLevelSerializable}")
    private String txIsolationLevelSerializable;
    @Value(value="${org.quartz.jobStore.selectWithLockSQL}")
    private String selectWithLockSQL;
    @Value(value="${org.quartz.plugin.triggHistory.class}")
    private String triggHistoryClass;
    @Value(value="${org.quartz.plugin.shutdownhook.class}")
    private String shutdownhookClass;
    @Value(value="${org.quartz.plugin.shutdownhook.cleanShutdown}")
    private String cleanShutdown;
    @Value(value="${org.quartz.dataSource.myDS.driver}")
    private String driver;
    @Value(value="${org.quartz.dataSource.myDS.URL}")
    private String URL;
    @Value(value="${org.quartz.dataSource.myDS.user}")
    private String user;
    @Value(value="${org.quartz.dataSource.myDS.password}")
    private String password;
    @Value(value="${org.quartz.dataSource.myDS.maxConnections}")
    private String maxConnections;
    @Value(value="${org.quartz.dataSource.myDS.max-active}")
    private int maxActive;
    @Value(value="${org.quartz.dataSource.myDS.min-idle}")
    private int minIdle;
    @Value(value="${org.quartz.dataSource.myDS.initial-size}")
    private int initialSize;
    @Value(value="${org.quartz.dataSource.myDS.test-on-borrow}")
    private boolean testOnBorrow;

    private Properties quartzProperties() throws IOException {
        Properties prop = new Properties();
        prop.put("quartz.scheduler.instanceName", this.quartzInstanceName);
        prop.put("org.quartz.scheduler.instanceId", this.instanceId);
        prop.put("org.quartz.scheduler.skipUpdateCheck", this.skipUpdateCheck);
        prop.put("org.quartz.scheduler.jmx.export", this.export);
        prop.put("org.quartz.jobStore.class", this.jobStoreClass);
        prop.put("org.quartz.jobStore.driverDelegateClass", this.driverDelegateClass);
        prop.put("org.quartz.jobStore.dataSource", this.dataSource);
        prop.put("org.quartz.jobStore.tablePrefix", this.tablePrefix);
        prop.put("org.quartz.jobStore.isClustered", this.isClustered);
        prop.put("org.quartz.jobStore.clusterCheckinInterval", this.clusterCheckinInterval);
        prop.put("org.quartz.jobStore.maxMisfiresToHandleAtATime", this.maxMisfiresToHandleAtATime);
        prop.put("org.quartz.jobStore.misfireThreshold", this.misfireThreshold);
        prop.put("org.quartz.jobStore.txIsolationLevelSerializable", this.txIsolationLevelSerializable);
        prop.put("org.quartz.jobStore.selectWithLockSQL", this.selectWithLockSQL);
        prop.put("org.quartz.threadPool.class", this.threadPoolClass);
        prop.put("org.quartz.threadPool.threadCount", this.threadCount);
        prop.put("org.quartz.threadPool.threadPriority", this.threadPriority);
        prop.put("org.quartz.threadPool.threadsInheritContextClassLoaderOfInitializingThread", this.threadsInheritContextClassLoaderOfInitializingThread);
        prop.put("org.quartz.dataSource.myDS.driver", this.driver);
        prop.put("org.quartz.dataSource.myDS.URL", this.URL);
        prop.put("org.quartz.dataSource.myDS.user", this.user);
        prop.put("org.quartz.dataSource.myDS.password", this.password);
        prop.put("org.quartz.dataSource.myDS.maxConnections", this.maxConnections);
        prop.put("org.quartz.plugin.triggHistory.class", this.triggHistoryClass);
        prop.put("org.quartz.plugin.shutdownhook.class", this.shutdownhookClass);
        prop.put("org.quartz.plugin.shutdownhook.cleanShutdown", this.cleanShutdown);
        return prop;
    }

    @Bean
    public JobFactory jobFactory(ApplicationContext applicationContext) {
        AutowiringSpringBeanJobFactory jobFactory = new AutowiringSpringBeanJobFactory();
        jobFactory.setApplicationContext(applicationContext);
        return jobFactory;
    }

    @Bean
    @ConfigurationProperties(prefix="datasource.secondary")
    public DataSource dataSourceQuartz() {
        DruidDataSource dataSource = new DruidDataSource();
        dataSource.setUrl(this.URL);
        dataSource.setUsername(this.user);
        dataSource.setPassword(this.password);
        if (this.initialSize > 0) {
            dataSource.setInitialSize(this.initialSize);
        }
        if (this.minIdle > 0) {
            dataSource.setMinIdle(this.minIdle);
        }
        if (this.maxActive > 0) {
            dataSource.setMaxActive(this.maxActive);
        }
        dataSource.setTestOnBorrow(this.testOnBorrow);
        try {
            dataSource.init();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return dataSource;
    }

    @Bean
    public SchedulerFactoryBean AdapiSchedulerFactoryBean(JobFactory jobFactory) throws IOException {
        SchedulerFactoryBean factory = new SchedulerFactoryBean();
        factory.setOverwriteExistingJobs(true);
        factory.setDataSource(this.dataSourceQuartz());
        factory.setJobFactory(jobFactory);
        factory.setStartupDelay(10);
        factory.setQuartzProperties(this.quartzProperties());
        factory.setAutoStartup(true);
        factory.setApplicationContextSchedulerContextKey("applicationContext");
        return factory;
    }
}

