/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adapi.quartz;

import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SchedulerService {
    @Autowired
    private Scheduler scheduler;

    public void addJobCron(String jobName, String jobGroupName, String triggerName, String triggerGroupName, Class jobClass, String cron) throws Exception {
        TriggerKey triggerKey = TriggerKey.triggerKey((String)triggerName, (String)triggerGroupName);
        Trigger trigger = this.scheduler.getTrigger(triggerKey);
        JobDetail jobDetail = JobBuilder.newJob((Class)jobClass).withIdentity(jobName, jobGroupName).build();
        CronScheduleBuilder cronScheduleBuilder = CronScheduleBuilder.cronSchedule((String)cron);
        trigger = TriggerBuilder.newTrigger().withIdentity(triggerName, triggerGroupName).withSchedule((ScheduleBuilder)cronScheduleBuilder.withMisfireHandlingInstructionDoNothing()).build();
        this.scheduler.scheduleJob(jobDetail, trigger);
    }

    public void deleteJob(String jobName, String jobGroupName) throws Exception {
        JobKey jobKey = JobKey.jobKey((String)jobName, (String)jobGroupName);
        this.scheduler.pauseJob(jobKey);
        this.scheduler.deleteJob(jobKey);
    }

    public void updateJobCron(String jobName, String jobGroupName, String triggerName, String triggerGroupName, Class jobClass, String cron) throws Exception {
        this.deleteJob(jobName, jobGroupName);
        this.addJobCron(jobName, jobGroupName, triggerName, triggerGroupName, jobClass, cron);
    }

    public void pauseJob(String jobName, String jobGroupName) throws Exception {
        JobKey jobKey = JobKey.jobKey((String)jobName, (String)jobGroupName);
        this.scheduler.pauseJob(jobKey);
    }

    public void resumeJob(String jobName, String jobGroupName, String triggerName, String triggerGroupName, Class jobClass, String cron) throws Exception {
        JobKey jobKey = JobKey.jobKey((String)jobName, (String)jobGroupName);
        if (this.scheduler.checkExists(jobKey)) {
            this.scheduler.resumeJob(jobKey);
        } else {
            this.addJobCron(jobName, jobGroupName, triggerName, triggerGroupName, jobClass, cron);
        }
    }
}

