/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adapi.service;

import com.alibaba.fastjson.JSON;
import com.bxm.adapi.commons.Metrics;
import com.bxm.adapi.config.RedisClient;
import com.bxm.adapi.model.constant.AdApiRedisKey;
import com.bxm.adapi.model.vo.AdMaterialApiVo;
import com.bxm.util.DateUtil;
import com.bxm.util.StringUtil;
import com.bxm.util.UuidUtil;
import com.bxm.util.dto.ValidateException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Metrics
@Service
public class AdMaterialApiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdMaterialApiService.class);
    @Autowired
    private RedisClient redisClient;
    @Value(value="${spring.profiles.active}")
    private String profilesActive;

    public AdMaterialApiVo getAdMaterial(HashMap<String, String> params) throws Exception {
        String redisKey = AdApiRedisKey.redisKey + AdApiRedisKey.adPositionApiMaterial + params.get("adPositionId");
        Object obj = this.redisClient.getObject(redisKey);
        if (obj != null) {
            AdMaterialApiVo adMaterialApiVo = (AdMaterialApiVo)JSON.parseObject((String)obj.toString(), AdMaterialApiVo.class);
            params.put("adPositionMaterialId", adMaterialApiVo.getAdPositionMaterialId() + "");
            params.put("mediaAdPositionId", adMaterialApiVo.getMediaAdPositionId() + "");
            this.calcMaterialExposureCount(params, adMaterialApiVo);
            adMaterialApiVo.setRedirectUrl(this.getAdClickUrl(params));
            adMaterialApiVo.setAdPositionMaterialId(null);
            adMaterialApiVo.setMediaAdPositionId(null);
            return adMaterialApiVo;
        }
        return null;
    }

    private void calcMaterialExposureCount(HashMap<String, String> params, AdMaterialApiVo adMaterialApiVo) throws ValidateException, Exception {
        String mediaAdPositionId = params.get("mediaAdPositionId");
        this.redisClient.incr(AdApiRedisKey.redisKey + AdApiRedisKey.adPositionMaterialTotalExposure + params.get("adPositionId") + AdApiRedisKey.adPositionMaterialId + adMaterialApiVo.getAdPositionMaterialId(), -1);
        this.redisClient.incr(AdApiRedisKey.redisKey + AdApiRedisKey.adPositionMaterialExposure + DateUtil.dateTo8String((Date)new Date()) + AdApiRedisKey.adPositionMaterialId + adMaterialApiVo.getAdPositionMaterialId(), null);
        this.redisClient.incr(AdApiRedisKey.redisKey + AdApiRedisKey.mediaAdPositionExposure + DateUtil.dateTo8String((Date)new Date()) + AdApiRedisKey.mediaAdPositionId + mediaAdPositionId, null);
    }

    private String getAdClickUrl(HashMap<String, String> params) throws UnsupportedEncodingException {
        String adApiHost = "https://api.bianxianmao.com/adapi/adMaterialApi/redirectAdUrl";
        if (StringUtil.equals((CharSequence)this.profilesActive, (CharSequence)"dev") || StringUtil.equals((CharSequence)this.profilesActive, (CharSequence)"test")) {
            adApiHost = "http://test.api.bianxianmao.com/adapi/adMaterialApi/redirectAdUrl";
        }
        StringBuffer redirectUrlSb = new StringBuffer(adApiHost);
        redirectUrlSb.append("?");
        if (params != null) {
            for (Map.Entry<String, String> e : params.entrySet()) {
                if (e.getValue() == null) continue;
                redirectUrlSb.append(URLEncoder.encode(e.getKey(), "UTF-8"));
                redirectUrlSb.append("=");
                redirectUrlSb.append(URLEncoder.encode(e.getValue().toString(), "UTF-8"));
                redirectUrlSb.append("&");
            }
        }
        String redirectUrlStr = redirectUrlSb.toString();
        redirectUrlStr = redirectUrlStr.substring(0, redirectUrlStr.length() - 1);
        return redirectUrlStr;
    }

    public String redirectAdUrl(HashMap<String, String> params) throws ValidateException, Exception {
        String mediaAdPositionId = params.get("mediaAdPositionId");
        String adPositionMaterialId = params.get("adPositionMaterialId");
        String adPositionId = params.get("adPositionId");
        String imei = params.get("imei");
        this.redisClient.incr(AdApiRedisKey.redisKey + AdApiRedisKey.adPositionMaterialTotalClick + adPositionId + AdApiRedisKey.adPositionMaterialId + adPositionMaterialId, -1);
        this.redisClient.incr(AdApiRedisKey.redisKey + AdApiRedisKey.adPositionMaterialClick + DateUtil.dateTo8String((Date)new Date()) + AdApiRedisKey.adPositionMaterialId + adPositionMaterialId, null);
        this.redisClient.incr(AdApiRedisKey.redisKey + AdApiRedisKey.mediaAdPositionClick + DateUtil.dateTo8String((Date)new Date()) + AdApiRedisKey.mediaAdPositionId + mediaAdPositionId, null);
        String[] adPositionIdStrs = adPositionId.split("-");
        String appKey = adPositionIdStrs[0];
        String appEntrance = adPositionIdStrs[1];
        String spm = UuidUtil.getUuidByJdk((boolean)true);
        params.put("appKey", appKey);
        params.put("appEntrance", appEntrance);
        params.put("business", "money");
        if (StringUtils.isNotBlank((String)imei)) {
            params.put("i", imei);
        }
        params.put("spm", spm);
        params.remove("mediaAdPositionId");
        params.remove("adPositionMaterialId");
        params.remove("adPositionId");
        return this.getRedirectAdUrl(params);
    }

    private String getRedirectAdUrl(HashMap<String, String> params) throws UnsupportedEncodingException {
        StringBuffer redirectUrlSb = new StringBuffer("http://m.cudaojia.com");
        redirectUrlSb.append("?");
        if (params != null) {
            for (Map.Entry<String, String> e : params.entrySet()) {
                if (e.getValue() == null) continue;
                redirectUrlSb.append(URLEncoder.encode(e.getKey(), "UTF-8"));
                redirectUrlSb.append("=");
                redirectUrlSb.append(URLEncoder.encode(e.getValue().toString(), "UTF-8"));
                redirectUrlSb.append("&");
            }
        }
        String redirectUrlStr = redirectUrlSb.toString();
        redirectUrlStr = redirectUrlStr.substring(0, redirectUrlStr.length() - 1);
        return redirectUrlStr;
    }

    public boolean exposure(String adPositionId, Long mediaAdPositionId, Long adPositionMaterialId) throws ValidateException, Exception {
        this.redisClient.incr(AdApiRedisKey.redisKey + AdApiRedisKey.adPositionMaterialTotalExposure + adPositionId + AdApiRedisKey.adPositionMaterialId + adPositionMaterialId, -1);
        this.redisClient.incr(AdApiRedisKey.redisKey + AdApiRedisKey.adPositionMaterialExposure + DateUtil.dateTo8String((Date)new Date()) + AdApiRedisKey.adPositionMaterialId + adPositionMaterialId, null);
        this.redisClient.incr(AdApiRedisKey.redisKey + AdApiRedisKey.mediaAdPositionExposure + DateUtil.dateTo8String((Date)new Date()) + AdApiRedisKey.mediaAdPositionId + mediaAdPositionId, null);
        return true;
    }

    public boolean click(String adPositionId, Long mediaAdPositionId, Long adPositionMaterialId) throws ValidateException, Exception {
        this.redisClient.incr(AdApiRedisKey.redisKey + AdApiRedisKey.adPositionMaterialTotalClick + adPositionId + AdApiRedisKey.adPositionMaterialId + adPositionMaterialId, -1);
        this.redisClient.incr(AdApiRedisKey.redisKey + AdApiRedisKey.adPositionMaterialClick + DateUtil.dateTo8String((Date)new Date()) + AdApiRedisKey.adPositionMaterialId + adPositionMaterialId, null);
        this.redisClient.incr(AdApiRedisKey.redisKey + AdApiRedisKey.mediaAdPositionClick + DateUtil.dateTo8String((Date)new Date()) + AdApiRedisKey.mediaAdPositionId + mediaAdPositionId, null);
        return true;
    }
}

