/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adapi.service;

import com.alibaba.fastjson.JSON;
import com.bxm.adapi.config.RedisClient;
import com.bxm.adapi.dal.ad_api_material.mapper.MaterialDoMapper;
import com.bxm.adapi.dal.ad_api_material.mapper.XunfeiApiConfigDoMapper;
import com.bxm.adapi.dal.ad_api_material.mapper.ext.AdPositionMaterialCtrDoMapperExt;
import com.bxm.adapi.dal.ad_api_material.mapper.ext.AdPositionMaterialDoMapperExt;
import com.bxm.adapi.dal.ad_api_material.mapper.ext.AdapiAdPositionMaterialCtrDoMapperExt;
import com.bxm.adapi.dal.ad_api_material.mapper.ext.AdapiAdPositionMaterialExposureClickDoMapperExt;
import com.bxm.adapi.dal.ad_api_material.mapper.ext.AdapiMediaAdPositionExposureClickDoMapperExt;
import com.bxm.adapi.dal.ad_api_material.mapper.ext.MediaAdPositionDoMapperExt;
import com.bxm.adapi.dal.ad_api_material.model.AdPositionMaterialDo;
import com.bxm.adapi.dal.ad_api_material.model.AdapiAdPositionMaterialCtrDo;
import com.bxm.adapi.dal.ad_api_material.model.AdapiAdPositionMaterialExposureClickDo;
import com.bxm.adapi.dal.ad_api_material.model.AdapiMediaAdPositionExposureClickDo;
import com.bxm.adapi.dal.ad_api_material.model.MaterialDo;
import com.bxm.adapi.dal.ad_api_material.model.MediaAdPositionDo;
import com.bxm.adapi.dal.ad_api_material.model.XunfeiApiConfigDo;
import com.bxm.adapi.integration.xunfei.UpdateXunfeiCreative;
import com.bxm.adapi.model.bo.AdPositionMaterialBo;
import com.bxm.adapi.model.constant.AdApiRedisKey;
import com.bxm.adapi.model.constant.Constant;
import com.bxm.adapi.model.dto.AdPositionMaterialDto;
import com.bxm.adapi.model.dto.AdPositionMaterialEditDto;
import com.bxm.adapi.model.dto.ImageDto;
import com.bxm.adapi.model.enums.AdPositionMateriaStatus;
import com.bxm.adapi.model.exception.AdApiCodeType;
import com.bxm.adapi.model.exception.AdApiException;
import com.bxm.adapi.model.ro.AdPositionMaterialRo;
import com.bxm.adapi.model.vo.AdMaterialApiVo;
import com.bxm.adapi.model.vo.AdMaterialCtrVo;
import com.bxm.adapi.model.vo.AdPositionMaterialCtrVo;
import com.bxm.adapi.quartz.SchedulerService;
import com.bxm.adapi.service.MaterialService;
import com.bxm.adapi.timer.TimmerCalcAdPositionMaterialCtrOfFiveMinutes;
import com.bxm.util.CommonValidate;
import com.bxm.util.DateUtil;
import com.bxm.util.DingtalkMsgUtil;
import com.bxm.util.RandomUtil;
import com.bxm.util.StringUtil;
import com.bxm.util.dto.ValidateException;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AdPositionMaterialService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdPositionMaterialService.class);
    @Autowired
    private AdPositionMaterialDoMapperExt adPositionMaterialMapperExt;
    @Autowired
    private MediaAdPositionDoMapperExt mediaAdPositionMapperExt;
    @Autowired
    private AdapiMediaAdPositionExposureClickDoMapperExt adapiMediaAdPositionExposureClickDoMapperExt;
    @Autowired
    private AdapiAdPositionMaterialExposureClickDoMapperExt adapiAdPositionMaterialExposureClickDoMapperExt;
    @Autowired
    private AdapiAdPositionMaterialCtrDoMapperExt adapiAdPositionMaterialCtrDoMapperExt;
    @Autowired
    private AdPositionMaterialCtrDoMapperExt adPositionMaterialCtrDoMapperExt;
    @Autowired
    private XunfeiApiConfigDoMapper xunfeiApiConfigDoMapper;
    @Autowired
    private SchedulerService taskService;
    @Autowired
    private RedisClient redisClient;
    @Resource
    private MaterialDoMapper materialDoMapper;

    @Transactional
    public boolean add(AdPositionMaterialEditDto adPositionMaterialEditDto) throws ValidateException, Exception {
        this.checkParam(adPositionMaterialEditDto);
        MaterialDo material = this.trans2Material(adPositionMaterialEditDto);
        if (this.materialDoMapper.insertSelective(material) != 1) {
            return false;
        }
        LOGGER.debug("materialId:{}", (Object)material.getId());
        AdPositionMaterialDo record = new AdPositionMaterialDo();
        BeanUtils.copyProperties((Object)adPositionMaterialEditDto, (Object)record);
        record.setImgUrl(material.getImgUrl());
        record.setSize(material.getSize());
        record.setMaterialId(material.getId());
        if (this.adPositionMaterialMapperExt.insertSelective(record) != 1) {
            throw new AdApiException(AdApiCodeType.OPERATION_NOT_EXECUTED);
        }
        adPositionMaterialEditDto.setId(record.getId());
        adPositionMaterialEditDto.setImgUrl(((ImageDto)adPositionMaterialEditDto.getImages().get(0)).getImgUrl());
        this.initAdPositionMaterialCacche(adPositionMaterialEditDto);
        return true;
    }

    private MaterialDo trans2Material(AdPositionMaterialEditDto adPositionMaterialEditDto) {
        MaterialDo material = new MaterialDo();
        BeanUtils.copyProperties((Object)adPositionMaterialEditDto, (Object)material);
        StringBuilder imageUrls = new StringBuilder();
        StringBuilder sizes = new StringBuilder();
        for (ImageDto image : adPositionMaterialEditDto.getImages()) {
            imageUrls.append(image.getImgUrl()).append("|");
            sizes.append(image.getSize()).append("|");
        }
        material.setImgUrl(imageUrls.subSequence(0, imageUrls.length() - 1).toString());
        material.setSize(sizes.subSequence(0, sizes.length() - 1).toString());
        material.setId(adPositionMaterialEditDto.getMaterialId());
        return material;
    }

    private void initAdPositionMaterialCacche(AdPositionMaterialEditDto record) throws Exception {
        AdMaterialCtrVo adMaterialCtrVo = new AdMaterialCtrVo();
        adMaterialCtrVo.setAdPositionMaterialId(record.getId());
        adMaterialCtrVo.setImgUrl(record.getImgUrl());
        adMaterialCtrVo.setStatus(Integer.valueOf(AdPositionMateriaStatus.Enable.getCode()));
        adMaterialCtrVo.setMediaAdPositionId(record.getMediaAdPositionId());
        this.redisClient.hset(AdApiRedisKey.redisKey + AdApiRedisKey.adPositionMaterial + AdApiRedisKey.mediaAdPositionId + record.getMediaAdPositionId(), record.getId().toString(), JSON.toJSONString((Object)adMaterialCtrVo));
        this.initAdPositionMaterialCtrCalcDb(adMaterialCtrVo);
        MediaAdPositionDo mediaAdPositionDo = this.mediaAdPositionMapperExt.selectByPrimaryKey(record.getMediaAdPositionId());
        if (mediaAdPositionDo != null) {
            AdMaterialApiVo adMaterialApiVo = new AdMaterialApiVo();
            adMaterialApiVo.setAdPositionMaterialId(record.getId());
            adMaterialApiVo.setMediaAdPositionId(record.getMediaAdPositionId());
            adMaterialApiVo.setImgUrl(record.getImgUrl());
            adMaterialApiVo.setImages(record.getImages());
            adMaterialApiVo.setTitle(record.getTitle());
            adMaterialApiVo.setIntroduction(record.getIntroduction());
            this.redisClient.setObject(AdApiRedisKey.redisKey + AdApiRedisKey.adPositionApiMaterial + mediaAdPositionDo.getAdPositionId(), JSON.toJSONString((Object)adMaterialApiVo));
            mediaAdPositionDo.setMaterialNum(Integer.valueOf(mediaAdPositionDo.getMaterialNum() + 1));
            if (this.mediaAdPositionMapperExt.updateByPrimaryKeySelective(mediaAdPositionDo) != 1) {
                LOGGER.error("\u66f4\u65b0\u5a92\u4f53\u5e7f\u544a\u4f4d\u7d20\u6750\u6570\u91cf\u5931\u8d25!");
                throw new AdApiException(AdApiCodeType.OPERATION_NOT_EXECUTED);
            }
            this.createTimer(record);
        }
        String adMaterialCtrVoRedisKey = AdApiRedisKey.redisKey + AdApiRedisKey.adPositionMaterial + AdApiRedisKey.mediaAdPositionId + record.getMediaAdPositionId();
        this.replaceAdPositionMaterial(mediaAdPositionDo.getAdPositionId(), adMaterialCtrVoRedisKey);
    }

    private void initAdPositionMaterialCtrCalcDb(AdMaterialCtrVo adMaterialCtrVo) {
        AdapiAdPositionMaterialCtrDo adapiAdPositionMaterialCtrDo = new AdapiAdPositionMaterialCtrDo();
        BeanUtils.copyProperties((Object)adMaterialCtrVo, (Object)adapiAdPositionMaterialCtrDo);
        adapiAdPositionMaterialCtrDo.setCalcCycle(Long.valueOf(0L));
        this.adapiAdPositionMaterialCtrDoMapperExt.insertSelective(adapiAdPositionMaterialCtrDo);
        AdapiAdPositionMaterialExposureClickDo adapiAdPositionMaterialExposureClickDo = new AdapiAdPositionMaterialExposureClickDo();
        adapiAdPositionMaterialExposureClickDo.setAdPositionMaterialClicknum(Long.valueOf(0L));
        adapiAdPositionMaterialExposureClickDo.setAdPositionMaterialExposurenum(Long.valueOf(0L));
        adapiAdPositionMaterialExposureClickDo.setAdPositionMaterialId(adMaterialCtrVo.getAdPositionMaterialId());
        adapiAdPositionMaterialExposureClickDo.setAdPositionMaterialCtr(Double.valueOf(0.0));
        this.adapiAdPositionMaterialExposureClickDoMapperExt.insertSelective(adapiAdPositionMaterialExposureClickDo);
        if (this.adapiMediaAdPositionExposureClickDoMapperExt.getListByMediaAdPositionId(adMaterialCtrVo.getMediaAdPositionId()).size() == 0) {
            AdapiMediaAdPositionExposureClickDo adapiMediaAdPositionExposureClickDo = new AdapiMediaAdPositionExposureClickDo();
            adapiMediaAdPositionExposureClickDo.setMediaAdPositionClicknum(Long.valueOf(0L));
            adapiMediaAdPositionExposureClickDo.setMediaAdPositionExposurenum(Long.valueOf(0L));
            adapiMediaAdPositionExposureClickDo.setMediaAdPositionCtr(Double.valueOf(0.0));
            adapiMediaAdPositionExposureClickDo.setMediaAdPositionId(adMaterialCtrVo.getMediaAdPositionId());
            this.adapiMediaAdPositionExposureClickDoMapperExt.insertSelective(adapiMediaAdPositionExposureClickDo);
        }
    }

    private void createTimer(AdPositionMaterialEditDto record) throws Exception {
        String adPositionMaterialCtrCalacInterval = DateUtil.dateToFormat((Date)DateUtil.increaseMinute((Date)new Date(), (int)5), (String)"ss mm HH dd MM ? yyyy");
        String jobName = "calcAdPositionMaterialCtrJob-" + record.getMediaAdPositionId() + "-" + record.getId();
        String jobTriggerName = "calcAdPositionMaterialCtrTrigger-" + record.getMediaAdPositionId() + "-" + record.getId();
        this.taskService.updateJobCron(jobName, "calcAdPositionMaterialCtrJobGroup", jobTriggerName, "calcAdPositionMaterialCtrTriggerGroup", TimmerCalcAdPositionMaterialCtrOfFiveMinutes.class, adPositionMaterialCtrCalacInterval);
    }

    private void resumeJob(AdPositionMaterialBo record) throws Exception {
        String adPositionMaterialCtrCalacInterval = DateUtil.dateToFormat((Date)DateUtil.increaseMinute((Date)new Date(), (int)5), (String)"ss mm HH dd MM ? yyyy");
        String jobName = "calcAdPositionMaterialCtrJob-" + record.getMediaAdPositionId() + "-" + record.getId();
        String jobTriggerName = "calcAdPositionMaterialCtrTrigger-" + record.getMediaAdPositionId() + "-" + record.getId();
        this.taskService.resumeJob(jobName, "calcAdPositionMaterialCtrJobGroup", jobTriggerName, "calcAdPositionMaterialCtrTriggerGroup", TimmerCalcAdPositionMaterialCtrOfFiveMinutes.class, adPositionMaterialCtrCalacInterval);
    }

    private void checkParam(AdPositionMaterialEditDto AdPositionMaterialEditDto2) {
        CommonValidate.me.checkParam((Object)AdPositionMaterialEditDto2.getImages(), "\u7d20\u6750\u56fe\u7247\u6216\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        if (AdPositionMaterialEditDto2.getImages().size() < 1) {
            throw new ValidateException("\u7d20\u6750\u56fe\u7247\u6216\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (AdPositionMaterialEditDto2.getImages().size() > 3) {
            throw new ValidateException("\u6700\u591a\u53ea\u80fd\u4e0a\u4f20\u4e09\u5f20\u56fe\u7247");
        }
        CommonValidate.me.checkParam((Object)AdPositionMaterialEditDto2.getMediaAdPositionId(), "\u5a92\u4f53\u5e7f\u544a\u4f4did\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Transactional
    public boolean update(AdPositionMaterialEditDto editDto) throws ValidateException, Exception {
        CommonValidate.me.checkParam((Object)editDto.getId(), "id\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkParam(editDto);
        AdPositionMaterialDo record = new AdPositionMaterialDo();
        BeanUtils.copyProperties((Object)editDto, (Object)record);
        MaterialDo materialDo = this.trans2Material(editDto);
        if (materialDo.getId() == null) {
            if (this.materialDoMapper.insertSelective(materialDo) != 1) {
                throw new AdApiException(AdApiCodeType.OPERATION_NOT_EXECUTED);
            }
            record.setMaterialId(materialDo.getId());
        } else {
            this.materialDoMapper.updateByPrimaryKeySelective(materialDo);
        }
        record.setImgUrl(materialDo.getImgUrl());
        record.setSize(materialDo.getSize());
        if (this.adPositionMaterialMapperExt.updateByPrimaryKeySelective(record) != 1) {
            LOGGER.error("\u66f4\u65b0adPositionMaterial\u5931\u8d25");
            throw new AdApiException(AdApiCodeType.OPERATION_NOT_EXECUTED);
        }
        String adMaterialCtrVoRedisKey = AdApiRedisKey.redisKey + AdApiRedisKey.adPositionMaterial + AdApiRedisKey.mediaAdPositionId + record.getMediaAdPositionId();
        String adMaterialCtrVoJson = this.redisClient.hget(adMaterialCtrVoRedisKey, record.getId().toString());
        if (StringUtil.isNotBlank((CharSequence)adMaterialCtrVoJson)) {
            AdMaterialCtrVo adMaterialCtrVo = (AdMaterialCtrVo)JSON.parseObject((String)adMaterialCtrVoJson, AdMaterialCtrVo.class);
            adMaterialCtrVo.setImgUrl(record.getImgUrl());
            this.redisClient.hdel(adMaterialCtrVoRedisKey, record.getId().toString());
            this.redisClient.hset(adMaterialCtrVoRedisKey, record.getId().toString(), JSON.toJSONString((Object)adMaterialCtrVo));
            this.refreshAdPositionMaterialCtrCalcDb(adMaterialCtrVo);
        }
        String adPositionId = this.mediaAdPositionMapperExt.queryAdPositionIdById(editDto.getMediaAdPositionId());
        this.replaceAdPositionMaterial(adPositionId, adMaterialCtrVoRedisKey);
        return true;
    }

    public PageInfo<AdPositionMaterialRo> getList(AdPositionMaterialDto adPositionMaterialDto) throws ValidateException {
        if (adPositionMaterialDto != null && adPositionMaterialDto.getPageSize() > 50) {
            adPositionMaterialDto.setPageSize(Integer.valueOf(50));
        }
        PageHelper.startPage((int)adPositionMaterialDto.getPageNum(), (int)adPositionMaterialDto.getPageSize());
        List bos = this.adPositionMaterialMapperExt.getList(adPositionMaterialDto);
        if (bos.size() == 0) {
            return new PageInfo();
        }
        PageInfo pageList = new PageInfo(bos.stream().map(bo -> {
            AdPositionMaterialRo ro = new AdPositionMaterialRo();
            BeanUtils.copyProperties((Object)bo, (Object)ro);
            ro.setImages(MaterialService.getImgs(bo.getImgUrl(), bo.getSize()));
            return ro;
        }).collect(Collectors.toList()));
        ArrayList<Long> adPositionMaterialIds = new ArrayList<Long>();
        for (AdPositionMaterialRo adPositionMaterialRo : pageList.getList()) {
            adPositionMaterialIds.add(adPositionMaterialRo.getId());
        }
        List adPositionMaterialCtrVoList = null;
        if (adPositionMaterialDto.getCtrCalcStartTime() != null && adPositionMaterialDto.getCtrCalcEndTime() != null) {
            String todayStr = DateUtil.dateTo8String((Date)new Date());
            if (StringUtil.equals((CharSequence)todayStr, (CharSequence)DateUtil.dateTo8String((Date)adPositionMaterialDto.getCtrCalcStartTime())) && StringUtil.equals((CharSequence)todayStr, (CharSequence)DateUtil.dateTo8String((Date)adPositionMaterialDto.getCtrCalcEndTime()))) {
                adPositionMaterialCtrVoList = this.adapiAdPositionMaterialExposureClickDoMapperExt.getListByAdPositionMaterialIds(adPositionMaterialIds);
            } else {
                adPositionMaterialCtrVoList = this.adPositionMaterialCtrDoMapperExt.getListByAdPositionMaterialIdAndDate(adPositionMaterialIds, adPositionMaterialDto.getCtrCalcStartTime(), adPositionMaterialDto.getCtrCalcEndTime());
                if (adPositionMaterialCtrVoList == null || adPositionMaterialCtrVoList.size() == 0) {
                    adPositionMaterialCtrVoList = this.adapiAdPositionMaterialExposureClickDoMapperExt.getListByAdPositionMaterialIds(adPositionMaterialIds);
                }
            }
        }
        HashMap<Long, AdPositionMaterialCtrVo> adPositionMaterialCtrVoMap = new HashMap<Long, AdPositionMaterialCtrVo>();
        if (adPositionMaterialCtrVoList != null && adPositionMaterialCtrVoList.size() > 0) {
            for (AdPositionMaterialCtrVo adPositionMaterialCtrVo : adPositionMaterialCtrVoList) {
                adPositionMaterialCtrVoMap.put(adPositionMaterialCtrVo.getAdPositionMaterialId(), adPositionMaterialCtrVo);
            }
        }
        for (AdPositionMaterialRo adPositionMaterialRo : pageList.getList()) {
            AdPositionMaterialCtrVo adPositionMaterialCtrVo = (AdPositionMaterialCtrVo)adPositionMaterialCtrVoMap.get(adPositionMaterialRo.getId());
            if (adPositionMaterialCtrVo != null) {
                adPositionMaterialRo.setClicknum(Long.valueOf(adPositionMaterialCtrVo.getTotalClicknum()));
                adPositionMaterialRo.setExposurenum(Long.valueOf(adPositionMaterialCtrVo.getTotalExposurenum()));
            }
            if (adPositionMaterialRo.getExposurenum() <= 0L || adPositionMaterialRo.getClicknum() <= 0L) continue;
            adPositionMaterialRo.setCtr(Double.valueOf(new BigDecimal((float)adPositionMaterialRo.getClicknum().longValue() / (float)adPositionMaterialRo.getExposurenum().longValue()).setScale(4, 1).doubleValue()));
        }
        return pageList;
    }

    @Transactional
    public boolean updateStatus(Long id, Integer status) throws ValidateException, Exception {
        boolean result;
        AdPositionMaterialDo adPositionMaterialDo;
        if (status.intValue() == AdPositionMateriaStatus.DELETE.getCode() && (adPositionMaterialDo = this.adPositionMaterialMapperExt.selectByPrimaryKey(id)).getStatus().intValue() == AdPositionMateriaStatus.Enable.getCode()) {
            throw new ValidateException("\u8bf7\u5148\u6682\u505c\u6b64\u4f7f\u7528\u7d20\u6750\u518d\u8fdb\u884c\u5220\u9664");
        }
        boolean bl = result = this.adPositionMaterialMapperExt.updateStatus(id, status) > 0;
        if (result) {
            result = this.refreshCache(status, result, id);
        }
        return result;
    }

    private boolean refreshCache(Integer status, boolean result, Long id) throws Exception {
        MediaAdPositionDo mediaAdPositionDo;
        AdPositionMaterialBo adPositionMaterialbo = this.adPositionMaterialMapperExt.selectInfoById(id);
        if (adPositionMaterialbo != null && (mediaAdPositionDo = this.mediaAdPositionMapperExt.selectByPrimaryKey(adPositionMaterialbo.getMediaAdPositionId())) != null) {
            String adMaterialCtrVoRedisKey = AdApiRedisKey.redisKey + AdApiRedisKey.adPositionMaterial + AdApiRedisKey.mediaAdPositionId + adPositionMaterialbo.getMediaAdPositionId();
            String jobName = "calcAdPositionMaterialCtrJob-" + adPositionMaterialbo.getMediaAdPositionId() + "-" + id;
            if (status.intValue() == AdPositionMateriaStatus.Disable.getCode()) {
                String adMaterialCtrVoJson = this.redisClient.hget(adMaterialCtrVoRedisKey, id.toString());
                if (StringUtil.isNotBlank((CharSequence)adMaterialCtrVoJson)) {
                    AdMaterialCtrVo adMaterialCtrVo = (AdMaterialCtrVo)JSON.parseObject((String)adMaterialCtrVoJson, AdMaterialCtrVo.class);
                    adMaterialCtrVo.setStatus(Integer.valueOf(AdPositionMateriaStatus.Disable.getCode()));
                    this.redisClient.hset(adMaterialCtrVoRedisKey, id.toString(), JSON.toJSONString((Object)adMaterialCtrVo));
                    this.refreshAdPositionMaterialCtrCalcDb(adMaterialCtrVo);
                    this.taskService.deleteJob(jobName, "calcAdPositionMaterialCtrJobGroup");
                }
            } else if (status.intValue() == AdPositionMateriaStatus.Enable.getCode()) {
                String adMaterialCtrVoJson = this.redisClient.hget(adMaterialCtrVoRedisKey, id.toString());
                if (StringUtil.isNotBlank((CharSequence)adMaterialCtrVoJson)) {
                    AdMaterialCtrVo adMaterialCtrVo = (AdMaterialCtrVo)JSON.parseObject((String)adMaterialCtrVoJson, AdMaterialCtrVo.class);
                    adMaterialCtrVo.setStatus(Integer.valueOf(AdPositionMateriaStatus.Enable.getCode()));
                    this.redisClient.hset(adMaterialCtrVoRedisKey, id.toString(), JSON.toJSONString((Object)adMaterialCtrVo));
                    this.refreshAdPositionMaterialCtrCalcDb(adMaterialCtrVo);
                } else {
                    AdMaterialCtrVo adMaterialCtrVo = new AdMaterialCtrVo();
                    adMaterialCtrVo.setAdPositionMaterialId(adPositionMaterialbo.getId());
                    adMaterialCtrVo.setImgUrl(adPositionMaterialbo.getImgUrl());
                    adMaterialCtrVo.setStatus(Integer.valueOf(AdPositionMateriaStatus.Enable.getCode()));
                    adMaterialCtrVo.setMediaAdPositionId(adPositionMaterialbo.getMediaAdPositionId());
                    this.redisClient.hset(AdApiRedisKey.redisKey + AdApiRedisKey.adPositionMaterial + AdApiRedisKey.mediaAdPositionId + adPositionMaterialbo.getMediaAdPositionId(), adPositionMaterialbo.getId().toString(), JSON.toJSONString((Object)adMaterialCtrVo));
                    AdMaterialApiVo adMaterialApiVo = new AdMaterialApiVo();
                    adMaterialApiVo.setAdPositionMaterialId(adPositionMaterialbo.getId());
                    adMaterialApiVo.setMediaAdPositionId(adPositionMaterialbo.getMediaAdPositionId());
                    adMaterialApiVo.setImgUrl(adPositionMaterialbo.getImgUrl());
                    adMaterialApiVo.setImages(MaterialService.getImgs(adPositionMaterialbo.getImgUrl(), adPositionMaterialbo.getSize()));
                    adMaterialApiVo.setTitle(adPositionMaterialbo.getTitle());
                    adMaterialApiVo.setIntroduction(adPositionMaterialbo.getIntroduction());
                    this.redisClient.setObject(AdApiRedisKey.redisKey + AdApiRedisKey.adPositionApiMaterial + mediaAdPositionDo.getAdPositionId(), JSON.toJSONString((Object)adMaterialApiVo));
                }
                this.resumeJob(adPositionMaterialbo);
            } else if (status.intValue() == AdPositionMateriaStatus.DELETE.getCode()) {
                this.redisClient.hdel(adMaterialCtrVoRedisKey, id.toString());
                this.redisClient.delObject(AdApiRedisKey.redisKey + AdApiRedisKey.adPositionApiMaterial + mediaAdPositionDo.getAdPositionId());
                mediaAdPositionDo.setMaterialNum(Integer.valueOf(mediaAdPositionDo.getMaterialNum() - 1));
                result = this.mediaAdPositionMapperExt.updateByPrimaryKeySelective(mediaAdPositionDo) == 1;
                this.adapiAdPositionMaterialCtrDoMapperExt.deleteByByMediaAdPositionIdAndAdPositionMaterialId(adPositionMaterialbo.getMediaAdPositionId(), id);
                this.taskService.deleteJob(jobName, "calcAdPositionMaterialCtrJobGroup");
            }
            this.replaceAdPositionMaterial(mediaAdPositionDo.getAdPositionId(), adMaterialCtrVoRedisKey);
        }
        return result;
    }

    public void refreshAdPositionMaterialCtrCalcDb(AdMaterialCtrVo adMaterialCtrVo) {
        AdapiAdPositionMaterialCtrDo adapiAdPositionMaterialCtrDo = new AdapiAdPositionMaterialCtrDo();
        BeanUtils.copyProperties((Object)adMaterialCtrVo, (Object)adapiAdPositionMaterialCtrDo);
        this.adapiAdPositionMaterialCtrDoMapperExt.updateByMediaAdPositionIdAndAdPositionMaterialId(adapiAdPositionMaterialCtrDo);
    }

    public void replaceAdPositionMaterial(String adPositionId, String adMaterialCtrVoRedisKey) throws Exception {
        Map<String, String> mapAdMaterialCtrVo = this.redisClient.hgetAll(adMaterialCtrVoRedisKey);
        ArrayList<AdMaterialCtrVo> adMaterialCtrVoList = new ArrayList<AdMaterialCtrVo>();
        for (String key : mapAdMaterialCtrVo.keySet()) {
            AdMaterialCtrVo adMaterialCtrVo = (AdMaterialCtrVo)JSON.parseObject((String)mapAdMaterialCtrVo.get(key), AdMaterialCtrVo.class);
            if (adMaterialCtrVo.getStatus().intValue() != AdPositionMateriaStatus.Enable.getCode()) continue;
            adMaterialCtrVoList.add(adMaterialCtrVo);
        }
        if (adMaterialCtrVoList.size() == 0) {
            return;
        }
        AdMaterialCtrVo maxAdMaterialCtrVo = this.selectMaxCtrMaterial(adMaterialCtrVoList);
        AdPositionMaterialBo adPositionMaterialbo = this.adPositionMaterialMapperExt.selectInfoById(maxAdMaterialCtrVo.getAdPositionMaterialId());
        AdMaterialApiVo adMaterialApiVo = new AdMaterialApiVo();
        adMaterialApiVo.setAdPositionMaterialId(adPositionMaterialbo.getId());
        adMaterialApiVo.setMediaAdPositionId(maxAdMaterialCtrVo.getMediaAdPositionId());
        adMaterialApiVo.setImgUrl(maxAdMaterialCtrVo.getImgUrl());
        adMaterialApiVo.setImages(MaterialService.getImgs(adPositionMaterialbo.getImgUrl(), adPositionMaterialbo.getSize()));
        adMaterialApiVo.setTitle(adPositionMaterialbo.getTitle());
        adMaterialApiVo.setIntroduction(adPositionMaterialbo.getIntroduction());
        this.redisClient.setObject(AdApiRedisKey.redisKey + AdApiRedisKey.adPositionApiMaterial + adPositionId, JSON.toJSONString((Object)adMaterialApiVo));
        if (adPositionId.indexOf("35135b347df24726a9802fa74db301be") != -1) {
            XunfeiApiConfigDo xunfeiApiConfigDo = this.xunfeiApiConfigDoMapper.selectByPrimaryKey(Integer.valueOf(1));
            if (xunfeiApiConfigDo == null) {
                DingtalkMsgUtil.sendMsg((String)"https://oapi.dingtalk.com/robot/send?access_token=1d1cb013250f30c9fc99fa4421e47603c1bde5743dabd2b713b5b1b2a3f9714e", (String)"api\u7d20\u6750\u5bf9\u63a5\u8baf\u98de\u63a5\u53e3\u53c2\u6570\u6ca1\u6709\u914d\u7f6e", (Boolean)false, (List)Constant.DINGTALK_WEBHOOK_AT_OPERATE_USER_LIST);
            } else {
                UpdateXunfeiCreative.update((String)xunfeiApiConfigDo.getAppId(), (String)xunfeiApiConfigDo.getAppKey(), (String)xunfeiApiConfigDo.getDomain(), (String)adMaterialApiVo.getImgUrl(), (String)adPositionId, (long)adMaterialApiVo.getAdPositionMaterialId(), (long)adMaterialApiVo.getMediaAdPositionId());
            }
        }
    }

    private AdMaterialCtrVo selectMaxCtrMaterial(List<AdMaterialCtrVo> adMaterialCtrVoList) {
        HashMap mapAdMaterialCtrVo = new HashMap();
        double maxCtrKey = 0.0;
        for (AdMaterialCtrVo adMaterialCtrVo : adMaterialCtrVoList) {
            double ctrKey = adMaterialCtrVo.getCtr();
            if (!mapAdMaterialCtrVo.containsKey(ctrKey)) {
                mapAdMaterialCtrVo.put(ctrKey, new ArrayList());
            }
            if (ctrKey > maxCtrKey) {
                maxCtrKey = ctrKey;
            }
            ((List)mapAdMaterialCtrVo.get(ctrKey)).add(adMaterialCtrVo);
        }
        TreeMap sortParams = new TreeMap(mapAdMaterialCtrVo);
        List maxList = (List)sortParams.get(maxCtrKey);
        return (AdMaterialCtrVo)maxList.get(RandomUtil.getRandomNum((int)maxList.size()));
    }
}

