/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adapi.service;

import com.alibaba.fastjson.JSON;
import com.bxm.adapi.config.RedisClient;
import com.bxm.adapi.dal.ad_api_material.mapper.ext.AdapiAdPositionMaterialCtrDoMapperExt;
import com.bxm.adapi.dal.ad_api_material.mapper.ext.AdapiAdPositionMaterialExposureClickDoMapperExt;
import com.bxm.adapi.dal.ad_api_material.mapper.ext.AdapiMediaAdPositionExposureClickDoMapperExt;
import com.bxm.adapi.dal.ad_api_material.mapper.ext.MediaAdPositionDoMapperExt;
import com.bxm.adapi.dal.ad_api_material.model.AdapiAdPositionMaterialCtrDo;
import com.bxm.adapi.dal.ad_api_material.model.AdapiAdPositionMaterialExposureClickDo;
import com.bxm.adapi.dal.ad_api_material.model.MediaAdPositionDo;
import com.bxm.adapi.model.constant.AdApiRedisKey;
import com.bxm.adapi.model.vo.AdMaterialApiVo;
import com.bxm.adapi.model.vo.AdMaterialCtrVo;
import com.bxm.adapi.quartz.SchedulerService;
import com.bxm.adapi.service.AdPositionMaterialService;
import com.bxm.adapi.timer.TimmerCalcAdPositionMaterialCtrOfFiveMinutes;
import com.bxm.util.DateUtil;
import com.bxm.util.dto.ValidateException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InitMaterialApiCacheService {
    @Autowired
    private AdapiMediaAdPositionExposureClickDoMapperExt adapiMediaAdPositionExposureClickDoMapperExt;
    @Autowired
    private AdapiAdPositionMaterialExposureClickDoMapperExt adapiAdPositionMaterialExposureClickDoMapperExt;
    @Autowired
    private AdapiAdPositionMaterialCtrDoMapperExt adapiAdPositionMaterialCtrDoMapperExt;
    @Autowired
    private MediaAdPositionDoMapperExt mediaAdPositionMapperExt;
    @Autowired
    private SchedulerService taskService;
    @Autowired
    private AdPositionMaterialService adPositionMaterialService;
    @Autowired
    private RedisClient redisClient;

    public void initCache() throws ValidateException, Exception {
        String adPositionApiMaterialKey = "adapi:adPositionApiMaterial:*";
        Map<String, Object> adPositionApiMaterialKeyMap = this.redisClient.getByKeys(adPositionApiMaterialKey);
        if (adPositionApiMaterialKeyMap != null && adPositionApiMaterialKeyMap.size() > 0) {
            return;
        }
        List listAdapiMediaAdPositionExposureClickDo = this.adapiMediaAdPositionExposureClickDoMapperExt.selectByExample(null);
        for (Object adapiMediaAdPositionExposureClickDo : listAdapiMediaAdPositionExposureClickDo) {
            String adPositionMaterialExposureKey = AdApiRedisKey.redisKey + AdApiRedisKey.mediaAdPositionExposure + DateUtil.dateTo8String((Date)new Date()) + AdApiRedisKey.mediaAdPositionId + adapiMediaAdPositionExposureClickDo.getMediaAdPositionId();
            this.redisClient.incrBy(adPositionMaterialExposureKey, adapiMediaAdPositionExposureClickDo.getMediaAdPositionExposurenum());
            String mediaAdPositionClickKey = AdApiRedisKey.redisKey + AdApiRedisKey.mediaAdPositionClick + DateUtil.dateTo8String((Date)new Date()) + AdApiRedisKey.mediaAdPositionId + adapiMediaAdPositionExposureClickDo.getMediaAdPositionId();
            this.redisClient.incrBy(mediaAdPositionClickKey, adapiMediaAdPositionExposureClickDo.getMediaAdPositionClicknum());
        }
        List listAdapiAdPositionMaterialExposureClickDo = this.adapiAdPositionMaterialExposureClickDoMapperExt.selectByExample(null);
        for (AdapiAdPositionMaterialExposureClickDo adapiAdPositionMaterialExposureClickDo : listAdapiAdPositionMaterialExposureClickDo) {
            String adPositionMaterialExposureKey = AdApiRedisKey.redisKey + AdApiRedisKey.adPositionMaterialExposure + DateUtil.dateTo8String((Date)new Date()) + AdApiRedisKey.adPositionMaterialId + adapiAdPositionMaterialExposureClickDo.getAdPositionMaterialId();
            this.redisClient.incrBy(adPositionMaterialExposureKey, adapiAdPositionMaterialExposureClickDo.getAdPositionMaterialExposurenum());
            String adPositionMaterialClickKey = AdApiRedisKey.redisKey + AdApiRedisKey.adPositionMaterialClick + DateUtil.dateTo8String((Date)new Date()) + AdApiRedisKey.adPositionMaterialId + adapiAdPositionMaterialExposureClickDo.getAdPositionMaterialId();
            this.redisClient.incrBy(adPositionMaterialClickKey, adapiAdPositionMaterialExposureClickDo.getAdPositionMaterialClicknum());
        }
        List listAdapiAdPositionMaterialCtrDo = this.adapiAdPositionMaterialCtrDoMapperExt.selectByExample(null);
        for (AdapiAdPositionMaterialCtrDo adapiAdPositionMaterialCtrDo : listAdapiAdPositionMaterialCtrDo) {
            AdMaterialCtrVo adMaterialCtrVo = new AdMaterialCtrVo();
            adMaterialCtrVo.setAdPositionMaterialId(adapiAdPositionMaterialCtrDo.getAdPositionMaterialId());
            adMaterialCtrVo.setImgUrl(adapiAdPositionMaterialCtrDo.getImgUrl());
            adMaterialCtrVo.setStatus(adapiAdPositionMaterialCtrDo.getStatus());
            adMaterialCtrVo.setMediaAdPositionId(adapiAdPositionMaterialCtrDo.getMediaAdPositionId());
            this.redisClient.hset(AdApiRedisKey.redisKey + AdApiRedisKey.adPositionMaterial + AdApiRedisKey.mediaAdPositionId + adapiAdPositionMaterialCtrDo.getMediaAdPositionId(), adapiAdPositionMaterialCtrDo.getAdPositionMaterialId().toString(), JSON.toJSONString((Object)adMaterialCtrVo));
            MediaAdPositionDo mediaAdPositionDo = this.mediaAdPositionMapperExt.selectByPrimaryKey(adapiAdPositionMaterialCtrDo.getMediaAdPositionId());
            if (mediaAdPositionDo == null) continue;
            AdMaterialApiVo adMaterialApiVo = new AdMaterialApiVo();
            adMaterialApiVo.setAdPositionMaterialId(adapiAdPositionMaterialCtrDo.getAdPositionMaterialId());
            adMaterialApiVo.setMediaAdPositionId(adapiAdPositionMaterialCtrDo.getMediaAdPositionId());
            adMaterialApiVo.setImgUrl(adapiAdPositionMaterialCtrDo.getImgUrl());
            this.redisClient.setObject(AdApiRedisKey.redisKey + AdApiRedisKey.adPositionApiMaterial + mediaAdPositionDo.getAdPositionId(), JSON.toJSONString((Object)adMaterialApiVo));
            String adMaterialCtrVoRedisKey = AdApiRedisKey.redisKey + AdApiRedisKey.adPositionMaterial + AdApiRedisKey.mediaAdPositionId + adapiAdPositionMaterialCtrDo.getMediaAdPositionId();
            this.adPositionMaterialService.replaceAdPositionMaterial(mediaAdPositionDo.getAdPositionId(), adMaterialCtrVoRedisKey);
            this.redisClient.incrBy(AdApiRedisKey.redisKey + AdApiRedisKey.adPositionMaterialTotalExposure + mediaAdPositionDo.getAdPositionId() + AdApiRedisKey.adPositionMaterialId + adapiAdPositionMaterialCtrDo.getAdPositionMaterialId(), adapiAdPositionMaterialCtrDo.getTotalExposurenum());
            this.redisClient.incrBy(AdApiRedisKey.redisKey + AdApiRedisKey.adPositionMaterialTotalClick + mediaAdPositionDo.getAdPositionId() + AdApiRedisKey.adPositionMaterialId + adapiAdPositionMaterialCtrDo.getAdPositionMaterialId(), adapiAdPositionMaterialCtrDo.getTotalClicknum());
            this.createNextTimer(adapiAdPositionMaterialCtrDo.getMediaAdPositionId(), adapiAdPositionMaterialCtrDo.getAdPositionMaterialId());
        }
    }

    private void createNextTimer(long mediaAdPositionId, long adPositionMaterialId) throws Exception {
        String adPositionMaterialCtrCalacInterval = DateUtil.dateToFormat((Date)DateUtil.increaseMinute((Date)new Date(), (int)5), (String)"ss mm HH dd MM ? yyyy");
        String jobName = "calcAdPositionMaterialCtrJob-" + mediaAdPositionId + "-" + adPositionMaterialId;
        String jobTriggerName = "calcAdPositionMaterialCtrTrigger-" + mediaAdPositionId + "-" + adPositionMaterialId;
        this.taskService.updateJobCron(jobName, "calcAdPositionMaterialCtrJobGroup", jobTriggerName, "calcAdPositionMaterialCtrTriggerGroup", TimmerCalcAdPositionMaterialCtrOfFiveMinutes.class, adPositionMaterialCtrCalacInterval);
    }
}

