/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adapi.service;

import com.bxm.adapi.dal.ad_api_material.mapper.ext.MaterialDoMapperExt;
import com.bxm.adapi.dal.ad_api_material.model.MaterialDo;
import com.bxm.adapi.model.dto.ImageDto;
import com.bxm.adapi.model.dto.MaterialDto;
import com.bxm.adapi.model.dto.MaterialEditDto;
import com.bxm.adapi.model.ro.MaterialRo;
import com.bxm.util.CommonValidate;
import com.bxm.util.RegExpValidatorUtils;
import com.bxm.util.dto.ValidateException;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MaterialService {
    @Autowired
    private MaterialDoMapperExt materialMapperExt;

    @Transactional
    public boolean add(MaterialEditDto materialEditDto) throws ValidateException, Exception {
        CommonValidate.me.checkParam((Object)materialEditDto.getName(), "\u7d20\u6750\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        CommonValidate.me.checkParamLength(materialEditDto.getName(), "\u7d20\u6750\u540d\u79f0\u4e0d\u80fd\u5927\u4e8e50\u4e2a\u5b57\u7b26", 50);
        this.checkParam(materialEditDto);
        MaterialDo record = this.trans2Material(materialEditDto);
        return this.materialMapperExt.insertSelective(record) == 1;
    }

    private void checkParam(MaterialEditDto materialEditDto) {
        if (materialEditDto.getImages() == null || materialEditDto.getImages().size() <= 0) {
            return;
        }
        for (ImageDto imageDto : materialEditDto.getImages()) {
            CommonValidate.me.checkParam((Object)imageDto.getImgUrl(), "\u7d20\u6750\u56fe\u7247\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
            CommonValidate.me.checkParam((Object)imageDto.getSize(), "\u7d20\u6750\u5c3a\u5bf8\u4e0d\u80fd\u4e3a\u7a7a");
            CommonValidate.me.checkParamLength(imageDto.getSize(), "\u7d20\u6750\u5c3a\u5bf8\u4e0d\u80fd\u5927\u4e8e50\u4e2a\u5b57\u7b26", 50);
            CommonValidate.me.checkParamLength(imageDto.getImgUrl(), "\u7d20\u6750\u56fe\u7247\u5730\u5740\u4e0d\u80fd\u5927\u4e8e500\u4e2a\u5b57\u7b26", 500);
            if (RegExpValidatorUtils.isUrl((String)imageDto.getImgUrl())) continue;
            throw new ValidateException("\u7d20\u6750\u56fe\u7247\u5730\u5740\u4e0d\u5408\u6cd5");
        }
    }

    @Transactional
    public boolean update(MaterialEditDto materialEditDto) throws ValidateException, Exception {
        CommonValidate.me.checkParam((Object)materialEditDto.getId(), "id\u4e0d\u80fd\u4e3a\u7a7a");
        if (materialEditDto.getName() != null) {
            CommonValidate.me.checkParamLength(materialEditDto.getName(), "\u7d20\u6750\u540d\u79f0\u4e0d\u80fd\u5927\u4e8e50\u4e2a\u5b57\u7b26", 50);
        }
        this.checkParam(materialEditDto);
        MaterialDo record = this.trans2Material(materialEditDto);
        return this.materialMapperExt.updateByPrimaryKeySelective(record) == 1;
    }

    public PageInfo<MaterialRo> getList(MaterialDto materialDto) throws ValidateException {
        if (materialDto != null && materialDto.getPageSize() > 50) {
            materialDto.setPageSize(Integer.valueOf(50));
        }
        PageHelper.startPage((int)materialDto.getPageNum(), (int)materialDto.getPageSize());
        return new PageInfo(this.materialMapperExt.getList(materialDto).stream().peek(material -> material.setImages(MaterialService.getImgs(material.getImgUrl(), material.getSize()))).collect(Collectors.toList()));
    }

    @Transactional
    public boolean deletes(List<Long> ids) throws ValidateException, Exception {
        CommonValidate.me.checkParam(ids);
        if (ids.size() == 0) {
            return false;
        }
        return this.materialMapperExt.deletes(ids) > 0;
    }

    private MaterialDo trans2Material(MaterialEditDto materialEditDto) {
        MaterialDo material = new MaterialDo();
        BeanUtils.copyProperties((Object)materialEditDto, (Object)material);
        StringBuilder imageUrls = new StringBuilder();
        StringBuilder sizes = new StringBuilder();
        for (ImageDto image : materialEditDto.getImages()) {
            imageUrls.append(image.getImgUrl()).append("|");
            sizes.append(image.getSize()).append("|");
        }
        material.setImgUrl(imageUrls.subSequence(0, imageUrls.length() - 1).toString());
        material.setSize(sizes.subSequence(0, sizes.length() - 1).toString());
        return material;
    }

    public static List<ImageDto> getImgs(String imgUrls, String imgSizes) {
        if (StringUtils.isEmpty((CharSequence)imgUrls)) {
            return new ArrayList<ImageDto>();
        }
        String[] imageUrls = imgUrls.split("\\|");
        String[] sizes = imgSizes.split("\\|");
        ArrayList<ImageDto> images = new ArrayList<ImageDto>(imageUrls.length);
        for (int i = 0; i < imageUrls.length; ++i) {
            String size = sizes.length <= i ? "" : sizes[i];
            images.add(new ImageDto(imageUrls[i], size));
        }
        return images;
    }
}

