/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adapi.service;

import com.bxm.adapi.dal.ad_api_material.mapper.ext.AdapiMediaAdPositionExposureClickDoMapperExt;
import com.bxm.adapi.dal.ad_api_material.mapper.ext.MediaAdPositionCtrDoMapperExt;
import com.bxm.adapi.dal.ad_api_material.mapper.ext.MediaAdPositionDoMapperExt;
import com.bxm.adapi.dal.ad_api_material.model.MediaAdPositionDo;
import com.bxm.adapi.model.dto.MediaAdPositionDto;
import com.bxm.adapi.model.dto.MediaAdPositionEditDto;
import com.bxm.adapi.model.ro.MediaAdPositionRo;
import com.bxm.adapi.model.vo.MediaAdPositionCtrVo;
import com.bxm.util.CommonValidate;
import com.bxm.util.DateUtil;
import com.bxm.util.dto.ValidateException;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import jodd.util.StringUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MediaAdPositionService {
    @Autowired
    private MediaAdPositionDoMapperExt mediaAdPositionMapperExt;
    @Autowired
    private MediaAdPositionCtrDoMapperExt mediaAdPositionCtrDoMapperExt;
    @Autowired
    private AdapiMediaAdPositionExposureClickDoMapperExt adapiMediaAdPositionExposureClickDoMapperExt;

    @Transactional
    public boolean add(MediaAdPositionEditDto mediaAdPositionEditDto) throws ValidateException, Exception {
        this.checkParam(mediaAdPositionEditDto);
        MediaAdPositionDo record = new MediaAdPositionDo();
        BeanUtils.copyProperties((Object)mediaAdPositionEditDto, (Object)record);
        return this.mediaAdPositionMapperExt.insertSelective(record) == 1;
    }

    private void checkParam(MediaAdPositionEditDto mediaAdPositionEditDto) {
        CommonValidate.me.checkParam((Object)mediaAdPositionEditDto.getAppName(), "appName\u4e0d\u80fd\u4e3a\u7a7a");
        CommonValidate.me.checkParam((Object)mediaAdPositionEditDto.getAdPositionName(), "\u5e7f\u544a\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        CommonValidate.me.checkParam((Object)mediaAdPositionEditDto.getAdPositionId(), "\u5e7f\u544a\u4f4did\u4e0d\u80fd\u4e3a\u7a7a");
        CommonValidate.me.checkParam((Object)mediaAdPositionEditDto.getImageSize(), "\u5e7f\u544a\u4f4d\u7d20\u6750\u56fe\u7247\u5c3a\u5bf8\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Transactional
    public boolean update(MediaAdPositionEditDto mediaAdPositionEditDto) throws ValidateException, Exception {
        CommonValidate.me.checkParam((Object)mediaAdPositionEditDto.getId(), "id\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkParam(mediaAdPositionEditDto);
        MediaAdPositionDo record = new MediaAdPositionDo();
        BeanUtils.copyProperties((Object)mediaAdPositionEditDto, (Object)record);
        return this.mediaAdPositionMapperExt.updateByPrimaryKeySelective(record) == 1;
    }

    public boolean updateByAdPositionId(MediaAdPositionEditDto mediaAdPositionEditDto) throws ValidateException, Exception {
        boolean result;
        CommonValidate.me.checkParam((Object)mediaAdPositionEditDto.getAdPositionId(), "\u5e7f\u544a\u4f4did\u4e0d\u80fd\u4e3a\u7a7a");
        MediaAdPositionDo record = new MediaAdPositionDo();
        BeanUtils.copyProperties((Object)mediaAdPositionEditDto, (Object)record);
        boolean bl = result = this.mediaAdPositionMapperExt.updateByAdPositionId(record) == 1;
        if (!result) {
            result = this.mediaAdPositionMapperExt.insertSelective(record) == 1;
        }
        return result;
    }

    public PageInfo<MediaAdPositionRo> getList(MediaAdPositionDto mediaAdPositionDto) throws ValidateException {
        PageInfo pageList;
        if (mediaAdPositionDto != null) {
            if (mediaAdPositionDto.getPageSize() > 50) {
                mediaAdPositionDto.setPageSize(Integer.valueOf(50));
            }
            PageHelper.startPage((int)mediaAdPositionDto.getPageNum(), (int)mediaAdPositionDto.getPageSize());
        }
        if ((pageList = new PageInfo(this.mediaAdPositionMapperExt.getList(mediaAdPositionDto))).getList().size() == 0) {
            return pageList;
        }
        ArrayList<Long> mediaAdPositionIds = new ArrayList<Long>();
        for (MediaAdPositionRo mediaAdPositionRo : pageList.getList()) {
            mediaAdPositionIds.add(mediaAdPositionRo.getId());
        }
        List mediaAdPositionCtrVoList = null;
        if (mediaAdPositionDto.getCtrCalcStartTime() != null && mediaAdPositionDto.getCtrCalcEndTime() != null) {
            String todayStr = DateUtil.dateTo8String((Date)new Date());
            if (StringUtil.equals((String)todayStr, (String)DateUtil.dateTo8String((Date)mediaAdPositionDto.getCtrCalcStartTime())) && StringUtil.equals((String)todayStr, (String)DateUtil.dateTo8String((Date)mediaAdPositionDto.getCtrCalcEndTime()))) {
                mediaAdPositionCtrVoList = this.adapiMediaAdPositionExposureClickDoMapperExt.getListByMediaAdPositionIds(mediaAdPositionIds);
            } else {
                mediaAdPositionCtrVoList = this.mediaAdPositionCtrDoMapperExt.getListByMediaAdPositionIdAndDate(mediaAdPositionIds, mediaAdPositionDto.getCtrCalcStartTime(), mediaAdPositionDto.getCtrCalcEndTime());
                if (mediaAdPositionCtrVoList == null || mediaAdPositionCtrVoList.size() == 0) {
                    mediaAdPositionCtrVoList = this.adapiMediaAdPositionExposureClickDoMapperExt.getListByMediaAdPositionIds(mediaAdPositionIds);
                }
            }
        }
        HashMap<Long, MediaAdPositionCtrVo> mediaAdPositionCtrVoMap = new HashMap<Long, MediaAdPositionCtrVo>();
        if (mediaAdPositionCtrVoList != null && mediaAdPositionCtrVoList.size() > 0) {
            for (MediaAdPositionCtrVo mediaAdPositionCtrVo : mediaAdPositionCtrVoList) {
                mediaAdPositionCtrVoMap.put(mediaAdPositionCtrVo.getMediaAdPositionId(), mediaAdPositionCtrVo);
            }
        }
        for (MediaAdPositionRo mediaAdPositionRo : pageList.getList()) {
            MediaAdPositionCtrVo mediaAdPositionCtrVo = (MediaAdPositionCtrVo)mediaAdPositionCtrVoMap.get(mediaAdPositionRo.getId());
            if (mediaAdPositionCtrVo != null) {
                mediaAdPositionRo.setClicknum(Long.valueOf(mediaAdPositionCtrVo.getTotalClicknum()));
                mediaAdPositionRo.setExposurenum(Long.valueOf(mediaAdPositionCtrVo.getTotalExposurenum()));
            }
            if (mediaAdPositionRo.getExposurenum() <= 0L || mediaAdPositionRo.getClicknum() <= 0L) continue;
            mediaAdPositionRo.setCtr(Double.valueOf(new BigDecimal((float)mediaAdPositionRo.getClicknum().longValue() / (float)mediaAdPositionRo.getExposurenum().longValue()).setScale(4, 1).doubleValue()));
        }
        return pageList;
    }

    @Transactional
    public boolean deletes(List<Long> ids) throws ValidateException, Exception {
        CommonValidate.me.checkParam(ids);
        if (ids.size() == 0) {
            return false;
        }
        return this.mediaAdPositionMapperExt.deletes(ids) > 0;
    }
}

