/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adapi.timer;

import com.bxm.adapi.config.RedisClient;
import com.bxm.adapi.dal.ad_api_material.mapper.AdPositionMaterialCtrDoMapper;
import com.bxm.adapi.dal.ad_api_material.model.AdPositionMaterialCtrDo;
import com.bxm.adapi.model.constant.AdApiRedisKey;
import com.bxm.adapi.model.constant.Constant;
import com.bxm.util.DateUtil;
import com.bxm.util.DingtalkMsgUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jodd.util.StringUtil;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TimmerCalcAdPositionMaterialCtrOfDay
implements Job {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimmerCalcAdPositionMaterialCtrOfDay.class);
    @Autowired
    private RedisClient redisClient;
    @Autowired
    private AdPositionMaterialCtrDoMapper adPositionMaterialCtrDoMapper;

    public void execute(JobExecutionContext context) {
        try {
            LOGGER.debug("-------- Start TimmerCalcAdPositionMaterialCtrOfDay-------" + DateUtil.dateTo14String((Date)new Date()));
            Date today = DateUtil.StringToDate((String)DateUtil.dateTo8String((Date)DateUtil.increaseMinute((Date)new Date(), (int)5)));
            Date dateTime = DateUtil.increaseDate((Date)today, (int)-1);
            String dateTimeStr = DateUtil.dateTo8String((Date)dateTime);
            Map<String, AdPositionMaterialCtrDo> adPositionMaterialCtrDoMap = this.calcExposure(dateTime, dateTimeStr);
            this.calcClick(dateTimeStr, adPositionMaterialCtrDoMap);
            this.insertDb(adPositionMaterialCtrDoMap);
            LOGGER.debug("-------- end TimmerCalcAdPositionMaterialCtrOfDay-------" + DateUtil.dateTo14String((Date)new Date()));
        }
        catch (Exception e) {
            DingtalkMsgUtil.sendErrorMsg((String)"https://oapi.dingtalk.com/robot/send?access_token=e1e9506d6b070295723ad46099162f2c1d4ea5ac74e78790b41587367ed3e474", (String)"adapi\u9879\u76ee\u6bcf\u5929\u51cc\u6668\u540c\u6b65\u5e7f\u544a\u4f4d\u7d20\u6750ctr\u51fa\u73b0\u9519\u8bef\u5f02\u5e38", (Boolean)false, (List)Constant.DINGTALK_WEBHOOK_AT_TEC_USER_LIST, (Exception)e);
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter((Writer)sw, true));
            LOGGER.error("---------> execute TimmerCalcAdPositionMaterialCtrOfDay error:{}", (Object)sw.toString());
        }
    }

    private void insertDb(Map<String, AdPositionMaterialCtrDo> adPositionMaterialCtrDoMap) {
        for (Map.Entry<String, AdPositionMaterialCtrDo> tmp : adPositionMaterialCtrDoMap.entrySet()) {
            AdPositionMaterialCtrDo adPositionMaterialCtrDo = tmp.getValue();
            if (adPositionMaterialCtrDo.getExposurenum() == null || adPositionMaterialCtrDo.getClicknum() == null || adPositionMaterialCtrDo.getExposurenum() == 0L || adPositionMaterialCtrDo.getClicknum() == 0L) {
                adPositionMaterialCtrDo.setCtr(Double.valueOf(0.0));
            } else {
                adPositionMaterialCtrDo.setCtr(Double.valueOf(new BigDecimal((float)adPositionMaterialCtrDo.getClicknum().longValue() / (float)adPositionMaterialCtrDo.getExposurenum().longValue()).setScale(4, 1).doubleValue()));
            }
            this.adPositionMaterialCtrDoMapper.insertSelective(adPositionMaterialCtrDo);
        }
    }

    private void calcClick(String dateTimeStr, Map<String, AdPositionMaterialCtrDo> adPositionMaterialCtrDoMap) {
        String adPositionMaterialClickKey = AdApiRedisKey.redisKey + AdApiRedisKey.adPositionMaterialClick + dateTimeStr + AdApiRedisKey.adPositionMaterialId + "*";
        Map<String, Object> adPositionMaterialClickMap = this.redisClient.getByKeys(adPositionMaterialClickKey);
        Set<String> adPositionMaterialClickMapKeySet = adPositionMaterialClickMap.keySet();
        for (String key : adPositionMaterialClickMapKeySet) {
            String[] keys = key.split(":");
            String adPositionMaterialId = keys[4];
            if (StringUtil.isBlank((CharSequence)adPositionMaterialId) || StringUtil.equals((String)adPositionMaterialId, (String)"null")) {
                LOGGER.error("key \"{}\" is error ", (Object)key);
                continue;
            }
            if (!adPositionMaterialCtrDoMap.containsKey(adPositionMaterialId)) continue;
            adPositionMaterialCtrDoMap.get(adPositionMaterialId).setClicknum(Long.valueOf(adPositionMaterialClickMap.get(key).toString()));
        }
    }

    private Map<String, AdPositionMaterialCtrDo> calcExposure(Date dateTime, String dateTimeStr) {
        String adPositionMaterialExposureKey = AdApiRedisKey.redisKey + AdApiRedisKey.adPositionMaterialExposure + dateTimeStr + AdApiRedisKey.adPositionMaterialId + "*";
        Map<String, Object> adPositionMaterialExposureMap = this.redisClient.getByKeys(adPositionMaterialExposureKey);
        Set<String> adPositionMaterialExposureMapKeySet = adPositionMaterialExposureMap.keySet();
        HashMap<String, AdPositionMaterialCtrDo> adPositionMaterialCtrDoMap = new HashMap<String, AdPositionMaterialCtrDo>();
        for (String key : adPositionMaterialExposureMapKeySet) {
            String[] keys = key.split(":");
            String adPositionMaterialId = keys[4];
            if (StringUtil.isBlank((CharSequence)adPositionMaterialId) || StringUtil.equals((String)adPositionMaterialId, (String)"null")) {
                LOGGER.error("key \"{}\" is error ", (Object)key);
                continue;
            }
            AdPositionMaterialCtrDo adPositionMaterialCtrDo = new AdPositionMaterialCtrDo();
            adPositionMaterialCtrDo.setDateTime(dateTime);
            adPositionMaterialCtrDo.setAdPositionMaterialId(Long.valueOf(adPositionMaterialId));
            adPositionMaterialCtrDo.setExposurenum(Long.valueOf(adPositionMaterialExposureMap.get(key).toString()));
            adPositionMaterialCtrDoMap.put(adPositionMaterialId, adPositionMaterialCtrDo);
        }
        return adPositionMaterialCtrDoMap;
    }
}

