/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adapi.timer;

import com.alibaba.fastjson.JSON;
import com.bxm.adapi.config.RedisClient;
import com.bxm.adapi.dal.ad_api_material.mapper.ext.AdapiAdPositionMaterialExposureClickDoMapperExt;
import com.bxm.adapi.dal.ad_api_material.mapper.ext.AdapiMediaAdPositionExposureClickDoMapperExt;
import com.bxm.adapi.dal.ad_api_material.mapper.ext.MediaAdPositionDoMapperExt;
import com.bxm.adapi.dal.ad_api_material.model.AdapiAdPositionMaterialExposureClickDo;
import com.bxm.adapi.dal.ad_api_material.model.AdapiMediaAdPositionExposureClickDo;
import com.bxm.adapi.dal.ad_api_material.model.MediaAdPositionDo;
import com.bxm.adapi.model.constant.AdApiRedisKey;
import com.bxm.adapi.model.constant.Constant;
import com.bxm.adapi.model.vo.AdMaterialCtrVo;
import com.bxm.adapi.quartz.SchedulerService;
import com.bxm.adapi.service.AdPositionMaterialService;
import com.bxm.util.DateUtil;
import com.bxm.util.DingtalkMsgUtil;
import com.bxm.util.StringUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TimmerCalcAdPositionMaterialCtrOfFiveMinutes
implements Job {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimmerCalcAdPositionMaterialCtrOfFiveMinutes.class);
    @Autowired
    private MediaAdPositionDoMapperExt mediaAdPositionMapperExt;
    @Autowired
    private AdapiMediaAdPositionExposureClickDoMapperExt adapiMediaAdPositionExposureClickDoMapperExt;
    @Autowired
    private AdapiAdPositionMaterialExposureClickDoMapperExt adapiAdPositionMaterialExposureClickDoMapperExt;
    @Autowired
    private SchedulerService taskService;
    @Autowired
    private AdPositionMaterialService adPositionMaterialService;
    @Autowired
    private RedisClient redisClient;

    public void execute(JobExecutionContext context) {
        LOGGER.debug("-------- Start TimmerAdPositionMaterialCtrCalc-------" + DateUtil.dateTo14String((Date)new Date()));
        String jobName = context.getJobDetail().getKey().getName();
        String[] jobNameStrs = jobName.split("-");
        Long mediaAdPositionId = Long.valueOf(jobNameStrs[1]);
        Long adPositionMaterialId = Long.valueOf(jobNameStrs[2]);
        MediaAdPositionDo mediaAdPositionDo = this.mediaAdPositionMapperExt.selectByPrimaryKey(mediaAdPositionId);
        if (mediaAdPositionDo == null) {
            return;
        }
        try {
            String exposureRedisKey = AdApiRedisKey.redisKey + AdApiRedisKey.adPositionMaterialTotalExposure + mediaAdPositionDo.getAdPositionId() + AdApiRedisKey.adPositionMaterialId + adPositionMaterialId;
            String clickRedisKey = AdApiRedisKey.redisKey + AdApiRedisKey.adPositionMaterialTotalClick + mediaAdPositionDo.getAdPositionId() + AdApiRedisKey.adPositionMaterialId + adPositionMaterialId;
            long exposurenumNewst = this.redisClient.get(exposureRedisKey) == null ? 0L : Long.valueOf(this.redisClient.get(exposureRedisKey));
            long clicknumNewst = this.redisClient.get(clickRedisKey) == null ? 0L : Long.valueOf(this.redisClient.get(clickRedisKey));
            String adMaterialCtrVoRedisKey = AdApiRedisKey.redisKey + AdApiRedisKey.adPositionMaterial + AdApiRedisKey.mediaAdPositionId + mediaAdPositionId;
            String adMaterialCtrVoJson = this.redisClient.hget(adMaterialCtrVoRedisKey, adPositionMaterialId.toString());
            if (StringUtil.isNotBlank((CharSequence)adMaterialCtrVoJson)) {
                AdMaterialCtrVo adMaterialCtrVo = (AdMaterialCtrVo)JSON.parseObject((String)adMaterialCtrVoJson, AdMaterialCtrVo.class);
                adMaterialCtrVo.setCalcCycle(adMaterialCtrVo.getCalcCycle() + 1L);
                this.calcFiveMinutesCtr(adMaterialCtrVo, exposurenumNewst, clicknumNewst);
                this.calcTowHoursCtr(adMaterialCtrVo);
                this.calcTwentyFourHoursCtr(adMaterialCtrVo);
                this.resetAdPositionMaterialCtr(adPositionMaterialId, adMaterialCtrVoRedisKey, adMaterialCtrVo);
                this.adPositionMaterialService.replaceAdPositionMaterial(mediaAdPositionDo.getAdPositionId(), adMaterialCtrVoRedisKey);
            }
            this.refreshDb(mediaAdPositionId, adPositionMaterialId);
            this.createNextTimer(jobName, mediaAdPositionId, adPositionMaterialId);
            LOGGER.debug("-------- end TimmerAdPositionMaterialCtrCalc-------" + DateUtil.dateTo14String((Date)new Date()));
        }
        catch (Exception e) {
            DingtalkMsgUtil.sendErrorMsg((String)"https://oapi.dingtalk.com/robot/send?access_token=e1e9506d6b070295723ad46099162f2c1d4ea5ac74e78790b41587367ed3e474", (String)("adapi\u9879\u76ee\u6bcf5\u5206\u949f\u8ba1\u7b97 \u5e7f\u544a\u4f4d\u7d20\u6750ctr\u51fa\u73b0\u9519\u8bef\u5f02\u5e38,jobName:" + jobName), (Boolean)false, (List)Constant.DINGTALK_WEBHOOK_AT_TEC_USER_LIST, (Exception)e);
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter((Writer)sw, true));
            LOGGER.error("---------> execute TimmerAdPositionMaterialCtrCalc error:{}", (Object)sw.toString());
        }
    }

    private void refreshDb(Long mediaAdPositionId, Long adPositionMaterialId) throws Exception {
        String mediaAdPositionClicknumKey;
        String dateTimeStr = DateUtil.dateTo8String((Date)new Date());
        String adPositionMaterialClicknumKey = AdApiRedisKey.redisKey + AdApiRedisKey.adPositionMaterialClick + dateTimeStr + AdApiRedisKey.adPositionMaterialId + adPositionMaterialId;
        long adPositionMaterialClicknum = this.redisClient.get(adPositionMaterialClicknumKey) == null ? 0L : Long.valueOf(this.redisClient.get(adPositionMaterialClicknumKey));
        String adPositionMaterialExposurenumKey = AdApiRedisKey.redisKey + AdApiRedisKey.adPositionMaterialExposure + dateTimeStr + AdApiRedisKey.adPositionMaterialId + adPositionMaterialId;
        long adPositionMaterialExposurenum = this.redisClient.get(adPositionMaterialExposurenumKey) == null ? 0L : Long.valueOf(this.redisClient.get(adPositionMaterialExposurenumKey));
        double adPositionMaterialCtr = 0.0;
        if (adPositionMaterialExposurenum > 0L && adPositionMaterialClicknum > 0L) {
            adPositionMaterialCtr = new BigDecimal((float)adPositionMaterialClicknum / (float)adPositionMaterialExposurenum).setScale(4, 1).doubleValue();
        }
        long mediaAdPositionClicknum = this.redisClient.get(mediaAdPositionClicknumKey = AdApiRedisKey.redisKey + AdApiRedisKey.mediaAdPositionClick + dateTimeStr + AdApiRedisKey.mediaAdPositionId + mediaAdPositionId) == null ? 0L : Long.valueOf(this.redisClient.get(mediaAdPositionClicknumKey));
        String mediaAdPositionExposurenumKey = AdApiRedisKey.redisKey + AdApiRedisKey.mediaAdPositionExposure + dateTimeStr + AdApiRedisKey.mediaAdPositionId + mediaAdPositionId;
        long mediaAdPositionExposurenum = this.redisClient.get(mediaAdPositionExposurenumKey) == null ? 0L : Long.valueOf(this.redisClient.get(mediaAdPositionExposurenumKey));
        double mediaAdPositionCtr = 0.0;
        if (mediaAdPositionExposurenum > 0L && mediaAdPositionClicknum > 0L) {
            mediaAdPositionCtr = new BigDecimal((float)mediaAdPositionClicknum / (float)mediaAdPositionExposurenum).setScale(4, 1).doubleValue();
        }
        AdapiAdPositionMaterialExposureClickDo adapiAdPositionMaterialExposureClickDo = new AdapiAdPositionMaterialExposureClickDo();
        adapiAdPositionMaterialExposureClickDo.setAdPositionMaterialClicknum(Long.valueOf(adPositionMaterialClicknum));
        adapiAdPositionMaterialExposureClickDo.setAdPositionMaterialExposurenum(Long.valueOf(adPositionMaterialExposurenum));
        adapiAdPositionMaterialExposureClickDo.setAdPositionMaterialId(adPositionMaterialId);
        adapiAdPositionMaterialExposureClickDo.setAdPositionMaterialCtr(Double.valueOf(adPositionMaterialCtr));
        this.adapiAdPositionMaterialExposureClickDoMapperExt.updateByAdPositionMaterialId(adapiAdPositionMaterialExposureClickDo);
        AdapiMediaAdPositionExposureClickDo adapiMediaAdPositionExposureClickDo = new AdapiMediaAdPositionExposureClickDo();
        adapiMediaAdPositionExposureClickDo.setMediaAdPositionClicknum(Long.valueOf(mediaAdPositionClicknum));
        adapiMediaAdPositionExposureClickDo.setMediaAdPositionExposurenum(Long.valueOf(mediaAdPositionExposurenum));
        adapiMediaAdPositionExposureClickDo.setMediaAdPositionId(mediaAdPositionId);
        adapiMediaAdPositionExposureClickDo.setMediaAdPositionCtr(Double.valueOf(mediaAdPositionCtr));
        this.adapiMediaAdPositionExposureClickDoMapperExt.updateByMediaAdPositionId(adapiMediaAdPositionExposureClickDo);
    }

    private void createNextTimer(String jobName, Long mediaAdPositionId, Long adPositionMaterialId) throws Exception {
        String adPositionMaterialCtrCalacInterval = DateUtil.dateToFormat((Date)DateUtil.increaseMinute((Date)new Date(), (int)5), (String)"ss mm HH dd MM ? yyyy");
        String jobTriggerName = "calcAdPositionMaterialCtrTrigger-" + mediaAdPositionId + "-" + adPositionMaterialId;
        this.taskService.updateJobCron(jobName, "calcAdPositionMaterialCtrJobGroup", jobTriggerName, "calcAdPositionMaterialCtrTriggerGroup", TimmerCalcAdPositionMaterialCtrOfFiveMinutes.class, adPositionMaterialCtrCalacInterval);
    }

    private void resetAdPositionMaterialCtr(Long adPositionMaterialId, String adMaterialCtrVoRedisKey, AdMaterialCtrVo adMaterialCtrVo) {
        if (adMaterialCtrVo.getTowHoursClicknum() < 100L) {
            if (adMaterialCtrVo.getTwentyFourHoursClicknum() < 100L) {
                if (adMaterialCtrVo.getTotalClicknum() < 100L) {
                    adMaterialCtrVo.setCtr(0.9);
                } else if (adMaterialCtrVo.getTotalExposurenum() > 0L && adMaterialCtrVo.getTotalClicknum() > 0L) {
                    adMaterialCtrVo.setCtr(new BigDecimal((float)adMaterialCtrVo.getTotalClicknum() / (float)adMaterialCtrVo.getTotalExposurenum()).setScale(4, 1).doubleValue());
                }
            } else {
                adMaterialCtrVo.setCtr(adMaterialCtrVo.getTwentyFourHoursCtr());
            }
        } else {
            adMaterialCtrVo.setCtr(adMaterialCtrVo.getTowHoursCtr());
        }
        if (adMaterialCtrVo.getCalcCycle() % 288L == 0L) {
            adMaterialCtrVo.setTwentyFourHoursExposurenumOfLast(adMaterialCtrVo.getTwentyFourHoursExposurenum());
            adMaterialCtrVo.setTwentyFourHoursClicknumOfLast(adMaterialCtrVo.getTwentyFourHoursClicknum());
            adMaterialCtrVo.setTwentyFourHoursExposurenum(0L);
            adMaterialCtrVo.setTwentyFourHoursClicknum(0L);
        }
        if (adMaterialCtrVo.getCalcCycle() % 24L == 0L) {
            adMaterialCtrVo.setTowHoursExposurenumOfLast(adMaterialCtrVo.getTowHoursExposurenum());
            adMaterialCtrVo.setTowHoursClicknumOfLast(adMaterialCtrVo.getTowHoursClicknum());
            adMaterialCtrVo.setTowHoursExposurenum(0L);
            adMaterialCtrVo.setTowHoursClicknum(0L);
        }
        this.redisClient.hset(adMaterialCtrVoRedisKey, adPositionMaterialId.toString(), JSON.toJSONString((Object)adMaterialCtrVo));
        this.adPositionMaterialService.refreshAdPositionMaterialCtrCalcDb(adMaterialCtrVo);
    }

    private void calcTwentyFourHoursCtr(AdMaterialCtrVo adMaterialCtrVo) {
        adMaterialCtrVo.setTwentyFourHoursExposurenum(adMaterialCtrVo.getTwentyFourHoursExposurenum() + adMaterialCtrVo.getFiveMinutesExposurenum());
        adMaterialCtrVo.setTwentyFourHoursClicknum(adMaterialCtrVo.getTwentyFourHoursClicknum() + adMaterialCtrVo.getFiveMinutesClicknum());
        if (adMaterialCtrVo.getTwentyFourHoursExposurenum() > 0L && adMaterialCtrVo.getTwentyFourHoursClicknum() > 0L) {
            adMaterialCtrVo.setTwentyFourHoursCtr(new BigDecimal((float)adMaterialCtrVo.getTwentyFourHoursClicknum() / (float)adMaterialCtrVo.getTwentyFourHoursExposurenum()).setScale(4, 1).doubleValue());
        } else {
            adMaterialCtrVo.setTwentyFourHoursCtr(0.0);
        }
    }

    private void calcTowHoursCtr(AdMaterialCtrVo adMaterialCtrVo) {
        adMaterialCtrVo.setTowHoursExposurenum(adMaterialCtrVo.getTowHoursExposurenum() + adMaterialCtrVo.getFiveMinutesExposurenum());
        adMaterialCtrVo.setTowHoursClicknum(adMaterialCtrVo.getTowHoursClicknum() + adMaterialCtrVo.getFiveMinutesClicknum());
        if (adMaterialCtrVo.getTowHoursExposurenum() > 0L && adMaterialCtrVo.getTowHoursClicknum() > 0L) {
            adMaterialCtrVo.setTowHoursCtr(new BigDecimal((float)adMaterialCtrVo.getTowHoursClicknum() / (float)adMaterialCtrVo.getTowHoursExposurenum()).setScale(4, 1).doubleValue());
        } else {
            adMaterialCtrVo.setTowHoursCtr(0.0);
        }
    }

    private void calcFiveMinutesCtr(AdMaterialCtrVo adMaterialCtrVo, long exposurenumNewst, long clicknumNewst) {
        adMaterialCtrVo.setFiveMinutesExposurenum(exposurenumNewst - adMaterialCtrVo.getTotalExposurenum());
        adMaterialCtrVo.setFiveMinutesClicknum(clicknumNewst - adMaterialCtrVo.getTotalClicknum());
        adMaterialCtrVo.setTotalExposurenum(exposurenumNewst);
        adMaterialCtrVo.setTotalClicknum(clicknumNewst);
        if (adMaterialCtrVo.getFiveMinutesExposurenum() > 0L && adMaterialCtrVo.getFiveMinutesClicknum() > 0L) {
            adMaterialCtrVo.setFiveMinutesCtr(new BigDecimal((float)adMaterialCtrVo.getFiveMinutesClicknum() / (float)adMaterialCtrVo.getFiveMinutesExposurenum()).setScale(4, 1).doubleValue());
        } else {
            adMaterialCtrVo.setFiveMinutesCtr(0.0);
        }
    }
}

