/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adapi.timer;

import com.bxm.adapi.config.RedisClient;
import com.bxm.adapi.dal.ad_api_material.mapper.MediaAdPositionCtrDoMapper;
import com.bxm.adapi.dal.ad_api_material.model.MediaAdPositionCtrDo;
import com.bxm.adapi.model.constant.AdApiRedisKey;
import com.bxm.adapi.model.constant.Constant;
import com.bxm.util.DateUtil;
import com.bxm.util.DingtalkMsgUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jodd.util.StringUtil;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TimmerCalcMediaAdPositionCtrOfDay
implements Job {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimmerCalcMediaAdPositionCtrOfDay.class);
    @Autowired
    private RedisClient redisClient;
    @Autowired
    private MediaAdPositionCtrDoMapper mediaAdPositionCtrDoMapper;

    public void execute(JobExecutionContext context) {
        try {
            LOGGER.debug("-------- Start TimmerCalcMediaAdPositionCtrOfDay-------" + DateUtil.dateTo14String((Date)new Date()));
            Date today = DateUtil.StringToDate((String)DateUtil.dateTo8String((Date)DateUtil.increaseMinute((Date)new Date(), (int)5)));
            Date dateTime = DateUtil.increaseDate((Date)today, (int)-1);
            String dateTimeStr = DateUtil.dateTo8String((Date)dateTime);
            Map<String, MediaAdPositionCtrDo> mediaAdPositionCtrDoMap = this.calcExposure(dateTime, dateTimeStr);
            this.calcClick(dateTimeStr, mediaAdPositionCtrDoMap);
            this.insertDb(mediaAdPositionCtrDoMap);
            LOGGER.debug("-------- end TimmerCalcMediaAdPositionCtrOfDay-------" + DateUtil.dateTo14String((Date)new Date()));
        }
        catch (Exception e) {
            DingtalkMsgUtil.sendErrorMsg((String)"https://oapi.dingtalk.com/robot/send?access_token=e1e9506d6b070295723ad46099162f2c1d4ea5ac74e78790b41587367ed3e474", (String)"adapi\u9879\u76ee\u6bcf\u5929\u51cc\u6668\u540c\u6b65\u5a92\u4f53\u5e7f\u544a\u4f4dctr\u51fa\u73b0\u9519\u8bef\u5f02\u5e38", (Boolean)false, (List)Constant.DINGTALK_WEBHOOK_AT_TEC_USER_LIST, (Exception)e);
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter((Writer)sw, true));
            LOGGER.error("---------> execute TimmerCalcMediaAdPositionCtrOfDay error:{}", (Object)sw.toString());
        }
    }

    private void insertDb(Map<String, MediaAdPositionCtrDo> mediaAdPositionCtrDoMap) {
        for (Map.Entry<String, MediaAdPositionCtrDo> tmp : mediaAdPositionCtrDoMap.entrySet()) {
            MediaAdPositionCtrDo mediaAdPositionCtrDo = tmp.getValue();
            if (mediaAdPositionCtrDo.getExposurenum() == null || mediaAdPositionCtrDo.getClicknum() == null || mediaAdPositionCtrDo.getExposurenum() == 0L || mediaAdPositionCtrDo.getClicknum() == 0L) {
                mediaAdPositionCtrDo.setCtr(Double.valueOf(0.0));
            } else {
                mediaAdPositionCtrDo.setCtr(Double.valueOf(new BigDecimal((float)mediaAdPositionCtrDo.getClicknum().longValue() / (float)mediaAdPositionCtrDo.getExposurenum().longValue()).setScale(4, 1).doubleValue()));
            }
            this.mediaAdPositionCtrDoMapper.insertSelective(mediaAdPositionCtrDo);
        }
    }

    private void calcClick(String dateTimeStr, Map<String, MediaAdPositionCtrDo> mediaAdPositionCtrDoMap) {
        String mediaAdPositionClickKey = AdApiRedisKey.redisKey + AdApiRedisKey.mediaAdPositionClick + dateTimeStr + AdApiRedisKey.mediaAdPositionId + "*";
        Map<String, Object> mediaAdPositionClickMap = this.redisClient.getByKeys(mediaAdPositionClickKey);
        Set<String> mediaAdPositionClickMapKeySet = mediaAdPositionClickMap.keySet();
        for (String key : mediaAdPositionClickMapKeySet) {
            String[] keys = key.split(":");
            String mediaAdPositionId = keys[4];
            if (StringUtil.isBlank((CharSequence)mediaAdPositionId) || StringUtil.equals((String)mediaAdPositionId, (String)"null")) {
                LOGGER.error("key \"{}\" is error ", (Object)key);
                continue;
            }
            if (!mediaAdPositionCtrDoMap.containsKey(mediaAdPositionId)) continue;
            mediaAdPositionCtrDoMap.get(mediaAdPositionId).setClicknum(Long.valueOf(mediaAdPositionClickMap.get(key).toString()));
        }
    }

    private Map<String, MediaAdPositionCtrDo> calcExposure(Date dateTime, String dateTimeStr) {
        String mediaAdPositionExposureKey = AdApiRedisKey.redisKey + AdApiRedisKey.mediaAdPositionExposure + dateTimeStr + AdApiRedisKey.mediaAdPositionId + "*";
        Map<String, Object> mediaAdPositionExposureMap = this.redisClient.getByKeys(mediaAdPositionExposureKey);
        Set<String> mediaAdPositionExposureMapKeySet = mediaAdPositionExposureMap.keySet();
        HashMap<String, MediaAdPositionCtrDo> mediaAdPositionCtrDoMap = new HashMap<String, MediaAdPositionCtrDo>();
        for (String key : mediaAdPositionExposureMapKeySet) {
            String[] keys = key.split(":");
            String mediaAdPositionId = keys[4];
            if (StringUtil.isBlank((CharSequence)mediaAdPositionId) || StringUtil.equals((String)mediaAdPositionId, (String)"null")) {
                LOGGER.error("key \"{}\" is error ", (Object)key);
                continue;
            }
            MediaAdPositionCtrDo mediaAdPositionCtrDo = new MediaAdPositionCtrDo();
            mediaAdPositionCtrDo.setDateTime(dateTime);
            mediaAdPositionCtrDo.setMediaAdPositionId(Long.valueOf(mediaAdPositionId));
            mediaAdPositionCtrDo.setExposurenum(Long.valueOf(mediaAdPositionExposureMap.get(key).toString()));
            mediaAdPositionCtrDoMap.put(mediaAdPositionId, mediaAdPositionCtrDo);
        }
        return mediaAdPositionCtrDoMap;
    }
}

