package com.bxm.report.service.activity.impl;

import com.bxm.app.model.constant.Constant;
import com.bxm.dao.adkeeper.AdPopupMapper;
import com.bxm.datapark.facade.adpopup.model.ro.PopupStyleRo;
import com.bxm.datapark.facade.adpopup.model.vo.PopupStyleVo;
import com.bxm.report.facade.constant.PopupStyleIntegration;
import com.bxm.report.model.base.Pagination;
import com.bxm.report.model.dao.popup.AdPopup;
import com.bxm.report.model.ro.PopupRo;
import com.bxm.report.model.vo.activity.PopupVo;
import com.bxm.report.service.activity.ActivityStatisticService;
import com.bxm.report.service.utils.DoubleUtil;
import org.dozer.Mapper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author yirenjie
 * createDate:  2018/10/15
 */
@Service
public class ActivityStatisticServiceImpl implements ActivityStatisticService {

    @Resource
    private AdPopupMapper adPopupMapper;

    @Resource
    private PopupStyleIntegration popupStyleIntegration;

    @Resource
    private Mapper mapper;

    @Override
    public Pagination getList(PopupRo popupRo) {
        if (popupRo.getPopupType() == null){
            throw new RuntimeException("样式类型不能为空");
        }
        popupRo.setPageSize(popupRo.getPageSize() > Constant.DEFAULT_MAX_PAGE_SIZE ? Constant.DEFAULT_MAX_PAGE_SIZE : popupRo.getPageSize());
        /*
         * 1. 先从mysql中查出符合条件的popupId
         * 2. 根据popId,查询出id,并建立映射关系
         * 3. 调用datapark获取每一行记录
         * 4. 根据step1查出的列表顺序对datapark返回的记录排序
         */
        // step.1
        Pagination pagination = new Pagination();
        pagination.setPageNo(popupRo.getPageNum());
        pagination.setPageSize(pagination.getPageSize());
        pagination.setTotalCount(adPopupMapper.countByRo(popupRo));
        if (pagination.getTotalCount() == 0){
            return pagination;
        }
        popupRo.setSkip(popupRo.getPageSize() * (popupRo.getPageNum() - 1));
        List<String> popIds = adPopupMapper.queryPopIdsByRo(popupRo);
        // step.2
        if (popIds.isEmpty()){
            return pagination;
        }
        List<AdPopup> adPopups = adPopupMapper.queryIdsAndPopIdsByPopId(popupRo, popIds);
        Map<Long, String> map = new HashMap<>();
        for (AdPopup adPopup : adPopups) {
            map.put(adPopup.getId(), adPopup.getPopupId());
        }
        // step.3
        PopupStyleRo ro = mapper.map(popupRo, PopupStyleRo.class);
        ro.setIds(map);
        Map<String, PopupStyleVo> resultMap = popupStyleIntegration.queryListByRo(ro);
        if (resultMap == null){
            return pagination;
        }
        // step.4
        List<PopupVo> list = new ArrayList<>();
        for (String popId : popIds) {
            PopupStyleVo popupStyleVo = resultMap.get(popId);
            if (popupStyleVo == null){
                continue;
            }
            PopupVo popupVo = mapper.map(popupStyleVo, PopupVo.class);
            popupVo.setClickPercent(DoubleUtil.percent(popupVo.getClickRate()));
            list.add(popupVo);
        }
        pagination.setList(list);
        return pagination;
    }
}
