package com.bxm.report.service.adkeeper;
/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

import com.bxm.app.model.vo.QueryPositionIdAndNameVo;
import com.bxm.report.model.base.Pagination;
import com.bxm.report.model.dto.adposition.AdpositionDto;
import com.bxm.report.model.dto.provideapp.ProvideAppDto;
import com.bxm.report.model.vo.adposition.AdpositionVo;
import com.bxm.report.model.vo.adposition.QueryMediaNameVo;
import com.bxm.report.model.vo.appcount.AppCountVo;

import java.util.List;
import java.util.Map;

/**
 * <h3>广告位</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2017/12/12 15:29
 */
public interface AdPositionService {

    public Pagination findAll(AdpositionDto adpositionDto);

    public Pagination findByAdTicketId(AdpositionDto adpositionDto);

    public Pagination findByIdsStr(AdpositionDto adpositionDto);

    public List<AdpositionVo> findBusinesses(String appKey, String keyword, String onlineStart, String onlineEnd);

    public List<AdpositionVo> findAllBusinesses();

    public Map<String, Integer> getBusinessNumberByAppKeys(List<String> appKeys);

    public Map<String, String> findAppKeysByOnline(List<String> list, String onlinStart, String onlineEndTemp);

    public List<AppCountVo> findBusinessByAppkeyTime(String appKey, String onlineStart, String onlineEndTemp);

    public List<AdpositionVo> findByBusinesses(String appKey, StringBuffer businesses);

    /**
     * @param appName
     * @return java.util.List<com.bxm.adsmanager.integration.adticketpopup.model.ProvideAppDto>
     * @description
     * @author 拉拉
     * @time 2018/3/7
     * @CopyRight 杭州微财科技有限公司
     */
    public List<ProvideAppDto> findAllByAppName(String appName);

    /**
     * @param PositonId
     * @return java.util.List<com.bxm.adsmanager.integration.adticketpopup.model.ProvideAppDto>
     * @description
     * @author 拉拉
     * @time 2018/3/7
     * @CopyRight 杭州微财科技有限公司
     */
    public List<ProvideAppDto> findAllByPositionId(String PositonId);


    /**
     * Description: 查询媒体名称或ID 根据媒体ID或名称
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/21 18:49
     */
    List<QueryMediaNameVo> queryMediaIdOrNameByKeywords(String keyWords);

    /**
     * Description: 查询广告券名称或ID 根据广告券ID或名称
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/21 18:49
     */
    List<QueryPositionIdAndNameVo> queryPositionIdOrNameByKeywords(String keyWords, String appKey);

}
