package com.bxm.report.service.adkeeper;
/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */


import com.bxm.report.model.common.Dictionaries;

import java.util.List;
import java.util.Map;

/**
 * <h3>字典</h3>
 * @author hcmony
 * @since V1.0.0, 2017/12/14 14:10
 */
public interface DictionariesService {

	/**
	 * 根据字典id查找所有字典
	 * @param typegroupid
	 * @return
	 */
	public List<Dictionaries> findAll(String typegroupid);

	/**
	 * 根据code查询字典
	 * @param code
	 * @return
	 */
	public Dictionaries findByCode(String code,String groupTypeCode);

	/**
	 * 根据code查询对应的字符
	 * @param code
	 * @param groupTypeCode
	 * @return
	 */
	String findNameByCode(String code, String groupTypeCode);
	
	/**  
	 * @Title: getCodeDetailMapByCode  
	 * @Description:  通过CODE码获取字典内容并拼成MAP
	 * @author xavier  
	 * @date 2018年3月6日
	 */  
	public Map<String, String> getCodeDetailMapByCode(String code);

}
