package com.bxm.report.service.adkeeper.impl;
/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

import com.bxm.app.model.ro.ProviderAppAdRo;
import com.bxm.app.model.vo.QueryPositionIdAndNameVo;
import com.bxm.dao.adkeeper.AdPositionMapper;
import com.bxm.dao.adkeeper.AdRulesMapper;
import com.bxm.dao.adkeeper.ext.AdPositionMapperExt;
import com.bxm.report.facade.app.AppEntranceFacadeIntegration;
import com.bxm.report.facade.app.ProviderAppFacadeIntegration;
import com.bxm.report.model.base.Pagination;
import com.bxm.report.model.dto.adposition.AdpositionDto;
import com.bxm.report.model.dto.provideapp.ProvideAppDto;
import com.bxm.report.model.enums.RuleTargetEnum;
import com.bxm.report.model.enums.RuleTypeEnum;
import com.bxm.report.model.utils.DataParkUtils;
import com.bxm.report.model.vo.adposition.AdpositionVo;
import com.bxm.report.model.vo.adposition.QueryMediaNameVo;
import com.bxm.report.model.vo.appcount.AppCountVo;
import com.bxm.report.service.adkeeper.AdPositionService;
import com.bxm.report.service.utils.ListUtil;
import com.bxm.util.StringUtil;
import com.bxm.util.dto.ValidateException;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * <h3>广告位</h3>
 * 
 * @author hcmony
 * @since V1.0.0, 2017/12/12 15:31
 */
@Service
public class AdPositionServiceImpl implements AdPositionService {

    private static final int    TWO = 2;

    @Autowired
    private AdPositionMapper adPositionMapper;
    @Autowired
    private AdRulesMapper adRulesMapper;
    @Autowired
    private AdPositionMapperExt adPositionMapperExt;
    @Autowired
    private AppEntranceFacadeIntegration appEntranceFacadeIntegration;
    @Autowired
    private ProviderAppFacadeIntegration providerAppFacadeIntegration;

    /**
     * @description 查询所有广告位
     * @author hcmony
     * @time 2017/12/12
     * @CopyRight 杭州微财网络科技有限公司
     * @param condition
     * @return com.bxm.adsmanager.model.vo.Pagination
     */
    @Override
    public Pagination findAll(AdpositionDto condition) {
        if (condition == null) {
            condition = new AdpositionDto();
        }

        Integer totalcount = adPositionMapper.totalcount(condition);
        List<AdpositionVo> objectList = new ArrayList<>(totalcount);
        // 如果广告券id,不为空的情况下，优先展示该券所对应的广告位，todo 这种做法不是特别好，等后面继续想更好的办法
        // 先查询出广告券关联的广告位，然后查剩下的所有广告位，自己分页处理
        if (null != condition.getAdTicketId()) {
            String result = adRulesMapper.findByTicketId(RuleTargetEnum.GUANGGAO_QUAN.getValue(),
                                                         RuleTypeEnum.GUANGGAOWEI.getValue(),
                                                         condition.getAdTicketId());
            // 1-c894feb044354ac99c960aa1483bae10-27,74e8bb5ad6ae464081691ab499d56643-56
            if (StringUtil.isNotBlank(result)) {
                result = result.substring(TWO);
                String[] resultArray = result.split(",");
                List<String> appkeyList = new ArrayList<>(resultArray.length);
                for (String s : resultArray) {
                    appkeyList.add(s);
                }
                // 查询券所对应的广告位
                List<AdpositionVo> adpositionVos = adPositionMapper.findAllByAppkey(appkeyList, condition);
                // 剩下的广告位
                List<AdpositionVo> adpositionVoList = adPositionMapper.findAllExcludeAppkey(adpositionVos, condition);
                adpositionVos.addAll(adpositionVoList);
                objectList = ListUtil.getTotalPage(adpositionVos, adpositionVos.size(), condition.getPageNum(),
                                                   condition.getPageSize());
            }
        }

        Pagination pagination = new Pagination();
        pagination.setList(objectList);
        // 如果广告券id没有找到对应的广告位
        if (CollectionUtils.isEmpty(objectList)) {
            List<AdpositionVo> list = adPositionMapper.findAll(condition);
            pagination.setList(list);
        }
        pagination.setPageSize(condition.getPageSize());
        pagination.setPageNo(condition.getPageNum());
        pagination.setTotalCount(totalcount);
        return pagination;
    }

    @Override
    public Pagination findByAdTicketId(AdpositionDto condition) {

        if (condition == null || null == condition.getAdTicketId()) {
            throw new ValidateException("adTicketId is null");
        }

        Integer totalcount = adPositionMapper.totalcount(condition);
        List<AdpositionVo> objectList = new ArrayList<>(totalcount);
        // 查询券所对应的广告位
        if (null != condition.getAdTicketId()) {
            String result = adRulesMapper.findByTicketId(RuleTargetEnum.GUANGGAO_QUAN.getValue(),
                                                         RuleTypeEnum.GUANGGAOWEI.getValue(),
                                                         condition.getAdTicketId());
            // 1-c894feb044354ac99c960aa1483bae10-27,74e8bb5ad6ae464081691ab499d56643-56
            if (StringUtil.isNotBlank(result)) {
                result = result.substring(TWO);
                String[] resultArray = result.split(",");
                List<String> appkeyList = new ArrayList<>(resultArray.length);
                for (String s : resultArray) {
                    appkeyList.add(s);
                }
                // 查询券所对应的广告位
                List<AdpositionVo> adpositionVos = adPositionMapper.findAllByAppkey(appkeyList, condition);
                objectList = ListUtil.getTotalPage(adpositionVos, adpositionVos.size(), condition.getPageNum(),
                                                   condition.getPageSize());
            }
        }
        Pagination pagination = new Pagination();
        pagination.setList(objectList);
        pagination.setPageSize(condition.getPageSize());
        pagination.setPageNo(condition.getPageNum());
        pagination.setTotalCount(totalcount);
        return pagination;
    }

    @Override
    public Pagination findByIdsStr(AdpositionDto condition) {

        Pagination pagination = new Pagination();
        List<AdpositionVo> objectList = new ArrayList<>();
        if (StringUtil.isNotBlank(condition.getIdsStr())) {
            String[] resultArray = condition.getIdsStr().split(",");
            List<String> appkeyList = new ArrayList<>(resultArray.length);
            for (String s : resultArray) {
                appkeyList.add(s);
            }
            // 查询券所对应的广告位
            List<AdpositionVo> adpositionVos = adPositionMapper.findAllByAppkey(appkeyList, condition);
            objectList = ListUtil.getTotalPage(adpositionVos, adpositionVos.size(), condition.getPageNum(),
                                               condition.getPageSize());
            pagination.setTotalCount(resultArray.length);
        }
        pagination.setList(objectList);
        pagination.setPageSize(condition.getPageSize());
        pagination.setPageNo(condition.getPageNum());
        return pagination;
    }

    @Override
    public List<ProvideAppDto> findAllByAppName(String appName) {
        List<ProvideAppDto> list = adPositionMapper.findAllByAppName(appName);
        return list;
    }

    @Override
    public List<ProvideAppDto> findAllByPositionId(String positonId) {
        List<String> position = new ArrayList<>();
        for (String positionId : positonId.split(",")) {
            position.add(positionId);
        }
        List<ProvideAppDto> list = adPositionMapper.findAllByPositionId(position);
        return list;
    }

    @Override
    public List<AdpositionVo> findBusinesses(String appKey, String keyword, String onlineStart, String onlineEnd) {

        // 封装查询条件
        Map<String, Object> map = Maps.newHashMap();
        map.put("appKey", appKey);
        map.put("businessName", keyword);
        map.put("onlineStart", onlineStart);
        map.put("onlineEnd", onlineEnd);
        List<AdpositionVo> businesses = adPositionMapperExt.findBusinesses(map);

        if (CollectionUtils.isNotEmpty(businesses)) {
            // 如果集合不为空,则直接返回结果
            return businesses;
        }
        return new ArrayList<AdpositionVo>();
    }

    @Override
    public List<AdpositionVo> findAllBusinesses() {
        Map<String, Object> map = new HashMap<>();
        List<AdpositionVo> allBusinesses = adPositionMapperExt.findAllBusinesses(map);
        if (CollectionUtils.isEmpty(allBusinesses)) {
            return new ArrayList<>();
        }
        return allBusinesses;
    }

    @Override
    public Map<String, Integer> getBusinessNumberByAppKeys(List<String> appKeys) {

        List<AppCountVo> businessNumberByAppKeys = adPositionMapperExt.getBusinessNumberByAppKeys(appKeys);

        Map<String, Integer> maps = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(businessNumberByAppKeys)) {
            for (AppCountVo appBusinessVo : businessNumberByAppKeys) {
                maps.put(appBusinessVo.getAppKey(), appBusinessVo.getBusinessCount());
            }

        }
        return maps;
    }

    @Override
    public Map<String, String> findAppKeysByOnline(List<String> list, String onlineStart, String onlineEndTemp) {
        Map<String, String> appCountMap = new HashMap<>();
        String onlineEnd = "";
        if (onlineEndTemp != null && onlineEndTemp != "") {
            onlineEnd = DataParkUtils.getNextDate(onlineEndTemp);
        }
        List<AppCountVo> appCountVos = adPositionMapperExt.AppKeysByOnline(onlineStart, onlineEnd, list);
        if (appCountVos.size() == 0 || appCountVos == null) {
            return new HashMap<>();
        }
        appCountVos.forEach(appCountVo -> {
            appCountMap.put(appCountVo.getAppKey(), appCountVo.getOnlineTime());
        });
        return appCountMap;
    }

    @Override
    public List<AppCountVo> findBusinessByAppkeyTime(String appKey, String onlineStart, String onlineEndTemp) {
        Map<String, Object> map = new HashMap<>();
        String onlineEnd = "";
        map.put("onlineStart", onlineStart);
        if (onlineEndTemp != null && onlineEndTemp != "") {
            onlineEnd = DataParkUtils.getNextDate(onlineEndTemp);
        }
        map.put("onlineEnd", onlineEnd);
        map.put("appKey", appKey);
        return adPositionMapperExt.findBusinessByAppkeyTime(map);

    }

    @Override
    public List<AdpositionVo> findByBusinesses(String appKey, StringBuffer sbBusinesses) {

        // 根据广告券名称模糊查询广告券信息
        List<String> businesses = new ArrayList<String>();
        Map<String, Object> paramsMap = new HashMap<String, Object>(16);
        if (sbBusinesses != null && StringUtils.isNotEmpty(sbBusinesses.toString())) {
            for (String business : sbBusinesses.toString().split(",")) {
                try {
                    businesses.add(business.replaceAll("ad-", ""));
                } catch (Exception e) {
                }
            }
            paramsMap.put("businesss", businesses);
        }
        paramsMap.put("appKey", appKey);
        if (businesses.size() == 0) {
            return new ArrayList<AdpositionVo>();
        }
        if (StringUtils.isEmpty(appKey)) {
            return new ArrayList<AdpositionVo>();
        }
        List<AdpositionVo> allBusinesses = adPositionMapperExt.findAllBusinesses(paramsMap);

        if (CollectionUtils.isEmpty(allBusinesses)) {
            return new ArrayList<AdpositionVo>();
        }
        return allBusinesses;
    }

    @Override
    public List<QueryMediaNameVo> queryMediaIdOrNameByKeywords(String keyWords) {
        if (StringUtils.isBlank(keyWords)) {
            return Collections.emptyList();
        }
        List<ProviderAppAdRo> providerAppAdRos = providerAppFacadeIntegration.getListByAppNameOrAppkey(keyWords);
        if (CollectionUtils.isEmpty(providerAppAdRos)) {
            return Collections.emptyList();
        }
        List<QueryMediaNameVo> list = new ArrayList<>(providerAppAdRos.size());
        for (ProviderAppAdRo providerAppAdRo : providerAppAdRos) {
            QueryMediaNameVo queryMediaNameVo = new QueryMediaNameVo();
            queryMediaNameVo.setAppKey(providerAppAdRo.getAppKey());
            queryMediaNameVo.setAppName(providerAppAdRo.getAppName());
            list.add(queryMediaNameVo);
        }
        return list;
    }

    @Override
    public List<QueryPositionIdAndNameVo> queryPositionIdOrNameByKeywords(String keyWords, String appKey) {
        if (StringUtils.isBlank(keyWords) && StringUtils.isBlank(appKey)) {
            return Collections.emptyList();
        }
        return appEntranceFacadeIntegration.getPositionIdAndName(keyWords, appKey);
    }
}
