package com.bxm.report.service.adkeeper.impl;
/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import com.bxm.dao.dictionary.DictionariesMapper;
import com.bxm.report.model.constant.RedisKeys;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import com.bxm.report.model.common.Dictionaries;
import com.bxm.report.service.adkeeper.DictionariesService;
import com.bxm.util.dto.ValidateException;

import javax.annotation.Resource;

/**
 * <h3>字典</h3>
 * 
 * @author hcmony
 * @since V1.0.0, 2017/12/11 17:21
 */
@Service
public class DictionariesServiceImpl implements DictionariesService {

    @Autowired
    private DictionariesMapper dictionariesMapper;

    @Resource
    private StringRedisTemplate stringRedisTemplate;

    /**
     * 根据字典id查找所有字典
     * 
     * @param typegroupid
     * @return
     */
    @Override
    public List<Dictionaries> findAll(String typegroupid) {
        if (typegroupid == null) {
            throw new ValidateException("typegroupid must be not null");
        }
        return dictionariesMapper.findAll(typegroupid);
    }

    /**
     * 根据code查询字典
     * 
     * @param code
     * @return
     */
    @Override
    public Dictionaries findByCode(String code,String groupTypeCode) {
        if (code == null) {
            throw new ValidateException("typecode must be not null");
        }
        return dictionariesMapper.findByCode(code,groupTypeCode);
    }

    @Override
    public String findNameByCode(String code, String groupTypeCode) {
        if (StringUtils.isEmpty(code)) {
            return null;
        }
        if (StringUtils.isEmpty(groupTypeCode)) {
            return null;
        }
        String name = stringRedisTemplate.opsForValue().get(RedisKeys.getKey(RedisKeys.DICTIONAY, groupTypeCode, code));
        if (StringUtils.isNotEmpty(name)) {
            return name;
        }
        name = dictionariesMapper.findNameByCode(code, groupTypeCode);
        if (StringUtils.isNotEmpty(name)){
            stringRedisTemplate.opsForValue().set(RedisKeys.getKey(RedisKeys.DICTIONAY, groupTypeCode, code), name, 5L, TimeUnit.MINUTES);
        }
        return name;
    }

    /**
     * @Title: getCodeDetailMapByCode
     * @Description: 通过CODE码获取字典内容并拼成MAP
     * @author xavier
     * @date 2018年3月6日
     */
    @Override
    public Map<String, String> getCodeDetailMapByCode(String code) {
        Map<String, String> resultMap = new HashMap<>();
        List<Dictionaries> results = findAll(code);
        for (Dictionaries dictionaries : results) {
            resultMap.put(dictionaries.getTypecode(), dictionaries.getTypename());
        }
        return resultMap;
    }

}
