package com.bxm.report.service.adkeeper.impl;

import com.bxm.dao.adkeeper.AdTicketMapper;
import com.bxm.dao.adkeeper.ext.InfoActivityCertificateMapperExt;
import com.bxm.report.model.dao.activity.InfoActivityCertificate;
import com.bxm.report.model.dao.adticket.AdTicket;
import com.bxm.report.model.dto.advertiser.AdvertiserDto;
import com.bxm.report.service.adkeeper.InfoActivityCertificateService;
import com.bxm.util.StringUtil;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 广告券相关操作
 * @author ganquan
 * @version v1.1.4_Report
 * @fileName com.bxm.adsmanager.service.adkeeper.impl.InfoActivityCertificateServiceImpl.java
 * @CopyRright (c) 2018-微财科技有限公司
 * @created 2018-03-03 13:54:00
 * @modifier ganquan
 * @updated 2018-03-03 13:54:00
 */
@Service
public class InfoActivityCertificateServiceImpl implements InfoActivityCertificateService {

    /*@Autowired
    private InfoActivityCertificateMapperExt infoActivityCertificateMapperExt;*/
    @Autowired
    private AdTicketMapper adTicketMapper;

    /**
     * 根据广告券名称模糊查询广告券信息
     * @param keyword
     * @return
     */
    @Override
    public List<AdTicket> findCertificateByKeyword(String keyword) {

        //根据广告券名称模糊查询广告券信息

        Map<String,Object> maps = new HashMap<>(16);
        maps.put("keyword",keyword);
        List<AdTicket> certificateByKeyword = adTicketMapper.findCertificateByKeywords(maps);

        if (CollectionUtils.isEmpty(certificateByKeyword)){
            return new ArrayList<AdTicket>();
        }
        return certificateByKeyword;
    }


    @Override
    public List<AdTicket> findCertificateInfoByCertificates(StringBuffer ids) {

        //根据广告券名称模糊查询广告券信息
        List<Long> certificates = new ArrayList<Long>();
        Map<String,Object> paramsMap = new HashMap<String,Object>(16);
        if (ids!=null&& StringUtils.isNotEmpty(ids)){
            for (String id : ids.toString().split(",")) {
                try {
                    certificates.add(Long.valueOf(id));
                } catch (Exception e) {
                }
            }
            paramsMap.put("certificates", certificates);
        }
        if (certificates.size() == 0) {
            return null;
        }
        List<AdTicket> certificateInfos = adTicketMapper.findCertificateInfoByCertificates(paramsMap);

        if (CollectionUtils.isEmpty(certificateInfos)){
            return new ArrayList<AdTicket>();
        }
        return certificateInfos;
    }
    

    @Override
    public List<AdTicket> findCertificateByParams(String keyword, List<AdvertiserDto> advertiserList, Integer ticketType) {
      //根据广告券名称模糊查询广告券信息

        Map<String,Object> maps = new HashMap<>(16);
        maps.put("keyword",keyword);
        maps.put("ticketType",ticketType);
        if(CollectionUtils.isNotEmpty(advertiserList)) {
            maps.put("advertiserList",advertiserList);
        }
        List<AdTicket> certificateByKeyword = adTicketMapper.findCertificateByKeywords(maps);

        if (CollectionUtils.isEmpty(certificateByKeyword)){
            return new ArrayList<AdTicket>();
        }
        return certificateByKeyword;
    }

    @Override
    public List<AdTicket> findCertificateByParamsAndAe(String keyword, List<AdvertiserDto> advertiserList, Integer ticketType, String ae) {
        //根据广告券名称模糊查询广告券信息

        Map<String,Object> maps = new HashMap<>(16);
        maps.put("keyword",keyword);
        if(ticketType!=null){
            maps.put("ticketType",ticketType);
        }

        if(CollectionUtils.isNotEmpty(advertiserList)) {
            maps.put("advertiserList",advertiserList);
        }
        if (StringUtil.isNotBlank(ae)){
            maps.put("ae",ae);
        }
        List<AdTicket> certificateByKeyword = adTicketMapper.findCertificateByKeywords(maps);

        if (CollectionUtils.isEmpty(certificateByKeyword)){
            return new ArrayList<AdTicket>();
        }
        return certificateByKeyword;
    }

     @Override
     public List<AdTicket> findCertificateByAdvertiser(List<Long> list){
         List<AdTicket>  result = adTicketMapper.findTicketByAdvertiser(list);

        return CollectionUtils.isEmpty(result)?new ArrayList<AdTicket>():result;
    }
}
