package com.bxm.report.service.adkeeper.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.bxm.dao.adkeeper.ext.InfoAppMsgMapperExt;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.bxm.report.model.dao.app.InfoAppMsg;
import com.bxm.report.service.adkeeper.InfoAppMsgService;
import com.google.common.collect.Maps;

/**
 * @author ganquan
 * @version v1.1.4_Report
 * @fileName com.bxm.adsmanager.service.adkeeper.impl.InfoAppMsgServiceImpl.java
 * @CopyRright (c) 2018-微财科技有限公司
 * @created 2018-02-28 20:08:00
 * @modifier ganquan
 * @updated 2018-02-28 20:08:00
 */
@Service
public class InfoAppMsgServiceImpl implements InfoAppMsgService {

    @Autowired
    private InfoAppMsgMapperExt infoAppMsgMapperExt;

    @Override
    public List<InfoAppMsg> findAllAppkeys(String mediaName, String roleCode) {

        // 封装查询条件
        Map<String, Object> map = Maps.newHashMap();
        map.put("mediaName", mediaName);
        map.put("roleCode", roleCode);
        // BD或者媒介
        List<InfoAppMsg> allAppkeys = infoAppMsgMapperExt.findAppkeys(map);
        if (CollectionUtils.isNotEmpty(allAppkeys)) {
            // 如果集合不为空,则直接返回结果
            return allAppkeys;
        }
        return new ArrayList<InfoAppMsg>();
    }

    @Override
    public List<InfoAppMsg> findInfoAppByAppkeys(StringBuffer sbAppkeys) {
        // 根据广告券名称模糊查询广告券信息
        List<String> appkeys = new ArrayList<String>();
        Map<String, Object> paramsMap = new HashMap<String, Object>(16);
        if (sbAppkeys != null && StringUtils.isNotEmpty(sbAppkeys)) {
            for (String appkey : sbAppkeys.toString().split(",")) {
                appkeys.add(appkey);
            }
            paramsMap.put("appKeys", appkeys);
        }
        if (appkeys.size() == 0) {
            return null;
        }
        List<InfoAppMsg> certificateInfos = infoAppMsgMapperExt.findAll(paramsMap);

        if (CollectionUtils.isEmpty(certificateInfos)) {
            return new ArrayList<InfoAppMsg>();
        }
        return certificateInfos;
    }
}
