package com.bxm.report.service.auth.impl;
/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.bxm.report.model.redis.RedisClient;
import com.bxm.report.service.auth.ValidationService; 

/**
 * <h3>权限验证</h3>
 * <p>
 * </p>
 *
 * @author hcmony
 * @since V1.0.0, 2017/12/25 16:21
 */
@Service
public class ValidationServiceImpl implements ValidationService {

    private static final Logger logger  = Logger.getLogger(ValidationService.class);

    private final int           dbIndex = 13;
    @Autowired
    private RedisClient         redisClient;

    @Override
    public Object verifyAccessToken(String token) {
        try {
            return redisClient.get(dbIndex, token);
        } catch (Exception e) {
            logger.error("权限校验失败token:" + token + e.getMessage(), e);
            return null;
        }
    }

    // todo 权限开关 ，上线关闭
    @Override
    public Object testOnOff() {
        try {
            return redisClient.get(dbIndex, "AD:AUTH:AUTH");
        } catch (Exception e) {
            logger.error("权限校验失败token:" + e.getMessage(), e);
            return null;
        }

    }

}
