package com.bxm.report.service.datapark;


import com.bxm.datapark.facade.Page;
import com.bxm.datapark.facade.activity.ActivityReportVo;
import com.bxm.report.model.base.Pagination;
import com.bxm.report.model.dao.activity.ActivityCount;
import com.bxm.report.model.dto.activity.InfoActivityMsgDto;
import com.bxm.report.model.ro.ActivityReportRo;
import com.bxm.util.dto.ResultModel;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 处理DataPark返回来的数据
 *
 * @author zhangkai
 * @create 2018-02-27 16:25
 **/
public interface DataparkActivityService {

    /**
     * 装载新活动报表
     * @param resultModel
     * @return
     */
    ResultModel pullNewActivityData(ResultModel<Page> resultModel);

    void  newActivityReportExport(List<ActivityReportVo> activityReportVos, HttpServletResponse response);
    /**
     * 装载活动报表
     * @param resultModel
     * @return
     */
    ResultModel<Pagination> pullActivityData(ResultModel<Pagination> resultModel);

    /**
     * 导出活动报表
     * @param activityCounts
     */
    void activityReportExport(List<ActivityCount> activityCounts, HttpServletResponse response);

    /**
     * 装载活动报表开发者维度
     * @param resultModel
     * @return
     */
    ResultModel pullActivityAppData(ResultModel<Pagination> resultModel);

    /**
     * 导出活动报表开发者维度
     * @param activityCounts
     * @param response
     */
    void activityReportAppExport(List<ActivityCount> activityCounts, HttpServletResponse response);

    /**
     * 装载活动报表子链接维度
     * @param resultModel
     * @return
     */
    ResultModel pullActivityAppBusinessData(ResultModel<Pagination> resultModel);

    /**
     * 导出活动报表子链接维度
     * @param activityCounts
     * @param response
     */
    void activityReportAppBusinessExport(List<ActivityCount> activityCounts, HttpServletResponse response);

    /**
     * 装载活动报表按日维度
     * @param activityCounts
     * @return
     */
    ResultModel pullActivityByDate(List<ActivityCount> activityCounts);

    /**
     * 导出活动报表按日维度
     * @param activityCounts
     * @param response
     */
    void activityReportByDateExport(List<ActivityCount> activityCounts, HttpServletResponse response);


    /**
     * 装载活动报表子链接按日维度
     * @param activityCounts
     * @return
     */
    ResultModel pullActivityBusinessByDate(List<ActivityCount> activityCounts);

    /**
     * 导出活动报表子链接按日维度
     * @param activityCounts
     * @param response
     */
    void activityReportBusinessByDateExport(List<ActivityCount> activityCounts, HttpServletResponse response);


    /**
     * 获取活动IDS
     * @return
     */
    String getActivityIds(ActivityReportRo activityReportRo);

    /**
     * 获取开发者APPKEYS
     * @param appName
     * @return
     */
    String getAppKeys(String appName);


    /**
     * 获取开发者的子链接
     * @param appKey
     * @param businessName
     * @return
     */
    String getBusiness(String appKey, String businessName);

    /**
     * 获取模糊查询活动信息
     * @return
     */
    List<InfoActivityMsgDto> getActivityMsg(String keywords, String activityType, String activityPlan);

    /**
     * 开发都日报子链接活动按日报表
     * @param activityCounts 活动日报表列表
     * @param response
     */
    void appBusinessActivityDateReportExport(List<ActivityCount> activityCounts, HttpServletResponse response);
}
