package com.bxm.report.service.datapark;

import com.bxm.datapark.facade.weight.TicketWeightFeignCilent;
import com.bxm.datapark.facade.weight.TicketWeightHourVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * datapark 礼券-广告位-按小时权重浮动信息查询api
 *
 * @ClassName DataparkTicketWeightService
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/7/8 19:08
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/7/8 19:08
 **/
@Component
public class DataparkTicketWeightService {
    @Autowired
    TicketWeightFeignCilent ticketWeightFeignCilent;

    public TicketWeightHourVo getTicketHourWeight(String datetime,  String appKey, String business,
                                           String ticketId, int pageNum, int pageSize){
        return ticketWeightFeignCilent.getTicketHourWeight(datetime, appKey, business, ticketId, pageNum, pageSize);
    }
}
