package com.bxm.report.service.datapark;

import com.bxm.datapark.facade.Page;
import com.bxm.report.model.dto.analysis.AnalysisParamsDTO;

import java.util.Map;

/**
 * 文 件 名 :
 * CopyRright (c) 2008-xxxx:
 * 文件编号：
 * 创 建 人： hxpeng
 * 日 期： 2018/8/15 10:49
 * 修 改 人：
 * 日 期：
 * 描 述：券分析接口
 * 版 本 号： v1
 */
public interface TicketAnalysisService {

    /**
     * Description: 券分析接口
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/15 10:56
     */
    Page analysis(AnalysisParamsDTO paramsDTO, String analysisType);

    /**
     * Description: 分析图表
     * 2018-10-15优化，map 包含列表数据 和 一个图表分析map，  即 Map<page, List> 和 一个 Map<chart, Map<String, Map<String, Double>>>
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/16 11:49
     */
    Map analysisChart(AnalysisParamsDTO paramsDTO, String analysisType);
}
