package com.bxm.report.service.datapark.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.dao.adkeeper.TblActivityMapper;
import com.bxm.datapark.facade.Page;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSON;
import com.bxm.dao.adkeeper.ext.AdPositionMapperExt;
import com.bxm.dao.adkeeper.ext.InfoAppMsgMapperExt;
import com.bxm.datapark.facade.Page;
import com.bxm.datapark.facade.activity.ActivityReportVo;
import com.bxm.report.facade.acl.AclUserIntegration;
import com.bxm.report.facade.datapark.DataparkActivityPullerIntegration;
import com.bxm.report.model.base.Pagination;
import com.bxm.report.model.common.Dictionaries;
import com.bxm.report.model.dao.activity.ActivityCount;
import com.bxm.report.model.dao.activity.ActivityWithBLOBs;
import com.bxm.report.model.dao.app.InfoAppMsg;
import com.bxm.report.model.dto.activity.InfoActivityMsgDto;
import com.bxm.report.model.ro.ActivityReportRo;
import com.bxm.report.model.vo.activity.*;
import com.bxm.report.model.vo.adposition.AdpositionVo;
import com.bxm.report.model.vo.app.AppBusinessActivityDateVo;
import com.bxm.report.service.adkeeper.DictionariesService;
import com.bxm.report.service.datapark.DataparkActivityService;
import com.bxm.report.service.utils.ExcelUtil;
import com.bxm.util.StringUtil;
import com.bxm.util.dto.ResultModel;
import com.google.common.collect.Lists;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Datapark数据处理
 *
 * @author zhangkai
 * @create 2018-02-28 16:04
 **/
@Service
public class DataparkActivityServiceImpl implements DataparkActivityService {

    @Autowired
    //private ActivityMapper      activityMapper;
    private TblActivityMapper activityMapper;


    @Autowired
    private InfoAppMsgMapperExt infoAppMsgMapperExt;

    @Autowired
    private AdPositionMapperExt adPositionMapperExt;

    @Autowired
    private DictionariesService dictionariesService;

    @Resource
    private DataparkActivityPullerIntegration dataparkActivityPullerIntegration;

    @Resource
    private AclUserIntegration aclUserIntegration;

    @Override
    public ResultModel pullNewActivityData(ResultModel<Page> resultModel) {
        if (resultModel.getReturnValue() == null){
            ResultModel rs =new ResultModel();
            rs.setReturnValue(new com.bxm.datapark.facade.Page());
            return rs;
        }
        com.bxm.datapark.facade.Page pagination = resultModel.getReturnValue();
        //取到数据源
        List<ActivityReportVo>  activityReportVos = (List<ActivityReportVo>) pagination.getList();
        if (activityReportVos.isEmpty()){
            ResultModel rs =new ResultModel();
            rs.setReturnValue(new com.bxm.datapark.facade.Page());
            return rs;
        }
        Map<String,String> map=dictionariesService.getCodeDetailMapByCode("acttag");
        for (ActivityReportVo activityReportVo:activityReportVos){
            if (StringUtil.isNotBlank(activityReportVo.getActivityTag())){
                String s ="";
                String[] split = activityReportVo.getActivityTag().split(",");
                for (int i = 0; i <split.length ; i++) {
                    if (StringUtil.isNotBlank(map.get(split[i]))){
                        s+= (map.get(split[i])+",");
                    }
                }
                if (StringUtils.isNotBlank(s)) {
                    activityReportVo.setActivityTagShow(s.substring(0, s.length() - 1));
                }
            }
        }
        pagination.setList(activityReportVos);
        resultModel.setReturnValue(pagination);
        return resultModel;
    }

    /**
     * 导出新活动报表数据
     * 
     * @param
     */
    @Override
    public void newActivityReportExport(List<ActivityReportVo> activityReportVos, HttpServletResponse response) {
        List<NewActivityReportVo> newActivityReportVos = new ArrayList<>();
        for (ActivityReportVo activityReportVo : activityReportVos) {
            NewActivityReportVo newActivityReportVo = new NewActivityReportVo();
            BeanUtils.copyProperties(activityReportVo, newActivityReportVo);
            newActivityReportVos.add(newActivityReportVo);
        }
        // 整合后的数据
        ExcelUtil.exportExcel(newActivityReportVos, null, null, NewActivityReportVo.class, "活动报表.xls", response);
    }

    /**
     * 获取活动报表数据
     * 
     * @param resultModel
     * @return
     */
    @Override
    public ResultModel<Pagination> pullActivityData(ResultModel<Pagination> resultModel) {
        if (resultModel.getReturnValue() == null) {
            return new ResultModel();
        }
        Pagination pagination = resultModel.getReturnValue();
        // 取到数据源
        List<ActivityCount> activityCounts = (List<ActivityCount>) pagination.getList();
        if (activityCounts.isEmpty()) {
            return new ResultModel();
        }
        Map<Long, ActivityWithBLOBs> activityWithBLOBsMap = new HashMap<>();

        // 获取所有的活动ID
        List<Long> ids = new ArrayList<>();
        for (ActivityCount activityCount : activityCounts) {
            if (activityCount.getActivityId() != null) {
                ids.add(activityCount.getActivityId());
            }
        }
        Map<String, Object> idsMap = new HashMap<>();
        if (ids.size() > 0) {
            idsMap.put("ids", ids);
        }
        // 查询所有的活动
        List<ActivityWithBLOBs> activityWithBLOBsList = Lists.newArrayList();
        if (!idsMap.isEmpty()) {
            activityWithBLOBsList = activityMapper.findList(idsMap);
        }
        // 拼装到MAP中
        for (ActivityWithBLOBs activityWithBLOBs : activityWithBLOBsList) {
            activityWithBLOBsMap.put(activityWithBLOBs.getId(), activityWithBLOBs);
        }
        List<ActivityDailyReportVo> activityVos = new ArrayList<>();
        for (ActivityCount activityCount : activityCounts) {
            ActivityDailyReportVo activityVo = new ActivityDailyReportVo();
            // COPY属性
            BeanUtils.copyProperties(activityCount, activityVo);
            String activityName = activityWithBLOBsMap.getOrDefault(activityVo.getActivityId(),
                                                                    new ActivityWithBLOBs()).getActivityName();
            activityVo.setActivityName(StringUtils.isEmpty(activityName) ? "" : activityName);
            // 获取到活动类型
            String activitytype = activityWithBLOBsMap.getOrDefault(activityVo.getActivityId(),
                                                                    new ActivityWithBLOBs()).getActivityType();
            Dictionaries dictionaries = dictionariesService.findByCode(StringUtils.isEmpty(activitytype) ? "" : activitytype,"acttype");
            if (dictionaries != null) {
                activityVo.setActivityModelName(dictionaries.getTypename());
            }
            activityVo.setPerClickPvChange(getPerChangeName(activityCount));
            ActivityWithBLOBs activityWithBLOB = activityWithBLOBsMap.get(activityVo.getActivityId());
            setDesignerAndPlanner(activityWithBLOB, activityVo);
            activityVos.add(activityVo);
        }
        pagination.setList(activityVos);
        resultModel.setReturnValue(pagination);
        return resultModel;
    }

    /**
     * 导出活动报表
     * 
     * @param activityCounts
     */
    @Override
    public void activityReportExport(List<ActivityCount> activityCounts, HttpServletResponse response) {
        Map<Long, ActivityWithBLOBs> activityWithBLOBsMap = new HashMap<>();
        List<Long> ids = new ArrayList<>();
        for (ActivityCount activityCount : activityCounts) {
            if (activityCount.getActivityId() != null) {
                ids.add(activityCount.getActivityId());
            }
        }
        Map<String, Object> idsMap = new HashMap<>();
        if (ids.size() > 0) {
            idsMap.put("ids", ids);
        }
        // 查询所有的活动
        List<ActivityWithBLOBs> activityWithBLOBsList = Lists.newArrayList();
        if (!idsMap.isEmpty()) {
            activityWithBLOBsList = activityMapper.findList(idsMap);
        }
        // 拼装到MAP中
        for (ActivityWithBLOBs activityWithBLOBs : activityWithBLOBsList) {
            activityWithBLOBsMap.put(activityWithBLOBs.getId(), activityWithBLOBs);
        }
        List<ActivityDailyReportVo> activityVos = new ArrayList<>();
        for (ActivityCount activityCount : activityCounts) {
            ActivityDailyReportVo activityVo = new ActivityDailyReportVo();
            // COPY属性
            BeanUtils.copyProperties(activityCount, activityVo);
            String activityName = activityWithBLOBsMap.getOrDefault(activityVo.getActivityId(),
                                                                    new ActivityWithBLOBs()).getActivityName();
            activityVo.setActivityName(StringUtils.isEmpty(activityName) ? "" : activityName);
            // 获取到活动类型
            String activityType = activityWithBLOBsMap.getOrDefault(activityVo.getActivityId(),
                                                                    new ActivityWithBLOBs()).getActivityType();
            Dictionaries dictionaries = dictionariesService.findByCode(StringUtils.isEmpty(activityType) ? "" : activityType,"acttype");
            if (dictionaries != null) {
                activityVo.setActivityModelName(dictionaries.getTypename());
            }
            ActivityWithBLOBs activityWithBLOB = activityWithBLOBsMap.get(activityVo.getActivityId());
            setDesignerAndPlanner(activityWithBLOB, activityVo);

            activityVos.add(activityVo);
        }
        // 整合后的数据
        ExcelUtil.exportExcel(activityVos, null, null, ActivityDailyReportVo.class, "活动报表.xls", response);
    }

    /**
     * 装载活动报表开发者维度
     * 
     * @param resultModel
     * @return
     */
    @Override
    public ResultModel pullActivityAppData(ResultModel<Pagination> resultModel) {
        if (resultModel.getReturnValue() == null) {
            return new ResultModel();
        }
        Pagination pagination = resultModel.getReturnValue();
        // 取到数据源
        List<ActivityCount> activityCounts = (List<ActivityCount>) pagination.getList();
        if (activityCounts.isEmpty()) {
            return new ResultModel();
        }

        List<String> appKeys = new ArrayList<>();
        for (ActivityCount activityCount : activityCounts) {
            if (!StringUtils.isEmpty(activityCount.getAppKey())) {
                appKeys.add(activityCount.getAppKey());
            }
        }
        Map<String, Object> map = new HashMap<>();
        if (appKeys.size() > 0) {
            map.put("appKeys", appKeys);
        }
        // 查询所有的开发者
        List<InfoAppMsg> infoAppMsgs = Lists.newArrayList();
        if (!map.isEmpty()) {
            infoAppMsgs = infoAppMsgMapperExt.findAll(map);
        }
        Map<String, InfoAppMsg> appMsgMap = new HashMap<>();
        for (InfoAppMsg infoAppMsg : infoAppMsgs) {
            appMsgMap.put(infoAppMsg.getAppkey(), infoAppMsg);
        }
        List<ActivityAppVo> activityAppVos = new ArrayList<>();
        for (ActivityCount activityCount : activityCounts) {
            ActivityAppVo activityAppVo = new ActivityAppVo();
            BeanUtils.copyProperties(activityCount, activityAppVo);
            String appName = appMsgMap.getOrDefault(activityAppVo.getAppKey(), new InfoAppMsg()).getAppname();
            activityAppVo.setAppName(StringUtils.isEmpty(appName) ? "" : appName);
            activityAppVo.setPerClickPv(activityCount.getPerClickPv());
            activityAppVo.setPerClickPvChange(getPerChangeName(activityCount));
            activityAppVos.add(activityAppVo);
        }
        pagination.setList(activityAppVos);
        resultModel.setReturnValue(pagination);
        return resultModel;
    }

    /**
     * 导出活动报表开发者维度
     * 
     * @param activityCounts
     * @param response
     */
    @Override
    public void activityReportAppExport(List<ActivityCount> activityCounts, HttpServletResponse response) {
        List<String> appKeys = new ArrayList<>();
        for (ActivityCount activityCount : activityCounts) {
            if (!StringUtils.isEmpty(activityCount.getAppKey())) {
                appKeys.add(activityCount.getAppKey());
            }
        }
        Map<String, Object> map = new HashMap<>();
        if (appKeys.size() > 0) {
            map.put("appKeys", appKeys);
        }
        // 查询所有的开发者
        List<InfoAppMsg> infoAppMsgs = Lists.newArrayList();
        if (!map.isEmpty()) {
            infoAppMsgs = infoAppMsgMapperExt.findAll(map);
        }
        Map<String, InfoAppMsg> appMsgMap = new HashMap<>();
        for (InfoAppMsg infoAppMsg : infoAppMsgs) {
            appMsgMap.put(infoAppMsg.getAppkey(), infoAppMsg);
        }
        List<ActivityAppVo> activityAppVos = new ArrayList<>();
        for (ActivityCount activityCount : activityCounts) {
            ActivityAppVo activityAppVo = new ActivityAppVo();
            BeanUtils.copyProperties(activityCount, activityAppVo);
            String appName = appMsgMap.getOrDefault(activityAppVo.getAppKey(), new InfoAppMsg()).getAppname();
            activityAppVo.setAppName(StringUtils.isEmpty(appName) ? "" : appName);
            activityAppVos.add(activityAppVo);
        }
        // 整合后的数据
        ExcelUtil.exportExcel(activityAppVos, null, null, ActivityAppVo.class, "活动报表.xls", response);
    }

    /**
     * 装载活动报表子链接维度
     * 
     * @param resultModel
     * @return
     */
    @Override
    public ResultModel pullActivityAppBusinessData(ResultModel<Pagination> resultModel) {
        if (resultModel.getReturnValue() == null) {
            return new ResultModel();
        }
        Pagination pagination = resultModel.getReturnValue();
        // 取到数据源
        List<ActivityCount> activityCounts = (List<ActivityCount>) pagination.getList();
        if (activityCounts.isEmpty()) {
            return new ResultModel();
        }
        Map<String, Object> map = new HashMap<>();
        List<String> businesss = new ArrayList<>();
        for (ActivityCount activityCount : activityCounts) {
            if (!StringUtils.isEmpty(activityCount.getBusiness())) {
                if (map.get("appKey") == null || map.get("appKey").equals("")) {
                    map.put("appKey", activityCount.getAppKey());
                }
                businesss.add(activityCount.getBusiness().replace("ad-", ""));
            }
        }
        if (businesss.size() > 0) {
            map.put("businesss", businesss);
        }
        // 取到所有的子渠道
        List<AdpositionVo> adpositionVos = Lists.newArrayList();
        if (!map.isEmpty()) {
            adpositionVos = adPositionMapperExt.findAllBusinesses(map);
        }
        Map<String, AdpositionVo> adpositionVoMap = new HashMap<>();
        for (AdpositionVo adpositionVo : adpositionVos) {
            adpositionVoMap.put(adpositionVo.getAppkey() + "-" + adpositionVo.getBusiness(), adpositionVo);
        }
        List<ActivityAppBusinessVo> activityAppBusinessVos = new ArrayList<>();
        for (ActivityCount activityCount : activityCounts) {
            ActivityAppBusinessVo activityAppBusinessVo = new ActivityAppBusinessVo();
            BeanUtils.copyProperties(activityCount, activityAppBusinessVo);
            String businessName = "";
            if (!StringUtils.isEmpty(activityCount.getBusiness())) {
                businessName = adpositionVoMap.getOrDefault(activityCount.getAppKey() + "-"
                                                            + activityCount.getBusiness().replace("ad-", ""),
                                                            new AdpositionVo()).getName();
            }
            activityAppBusinessVo.setBusinessName(StringUtils.isEmpty(businessName) ? "" : businessName);
            activityAppBusinessVo.setPerClickPv(activityCount.getPerClickPv());
            activityAppBusinessVo.setPerClickPvChange(getPerChangeName(activityCount));
            activityAppBusinessVos.add(activityAppBusinessVo);
        }
        pagination.setList(activityAppBusinessVos);
        resultModel.setReturnValue(pagination);
        return resultModel;
    }

    /**
     * 导出活动报表子链接维度
     * 
     * @param activityCounts
     * @param response
     */
    @Override
    public void activityReportAppBusinessExport(List<ActivityCount> activityCounts, HttpServletResponse response) {
        Map<String, Object> map = new HashMap<>();
        List<String> businesss = new ArrayList<>();
        for (ActivityCount activityCount : activityCounts) {
            if (!StringUtils.isEmpty(activityCount.getBusiness())) {
                if (map.get("appKey") == null || map.get("appKey").equals("")) {
                    map.put("appKey", activityCount.getAppKey());
                }
                businesss.add(activityCount.getBusiness().replace("ad-", ""));
            }
        }
        if (businesss.size() > 0) {
            map.put("businesss", businesss);
        }
        // 取到所有的子渠道
        List<AdpositionVo> adpositionVos = Lists.newArrayList();
        if (!map.isEmpty()) {
            adpositionVos = adPositionMapperExt.findAllBusinesses(map);
        }
        Map<String, AdpositionVo> adpositionVoMap = new HashMap<>();
        for (AdpositionVo adpositionVo : adpositionVos) {
            adpositionVoMap.put(adpositionVo.getAppkey() + "-" + adpositionVo.getBusiness(), adpositionVo);
        }
        List<ActivityAppBusinessVo> activityAppBusinessVos = new ArrayList<>();
        for (ActivityCount activityCount : activityCounts) {
            ActivityAppBusinessVo activityAppBusinessVo = new ActivityAppBusinessVo();
            BeanUtils.copyProperties(activityCount, activityAppBusinessVo);
            String businessName = "";
            if (!StringUtils.isEmpty(activityCount.getBusiness())) {
                businessName = adpositionVoMap.getOrDefault(activityCount.getAppKey() + "-"
                                                            + activityCount.getBusiness().replace("ad-", ""),
                                                            new AdpositionVo()).getName();
            }
            activityAppBusinessVo.setBusinessName(StringUtils.isEmpty(businessName) ? "" : businessName);
            activityAppBusinessVos.add(activityAppBusinessVo);
        }
        // 整合后的数据
        ExcelUtil.exportExcel(activityAppBusinessVos, null, null, ActivityAppBusinessVo.class, "活动报表.xls", response);
    }

    /**
     * 装载活动日报按日
     * 
     * @param activityCounts
     * @return
     */
    @Override
    public ResultModel pullActivityByDate(List<ActivityCount> activityCounts) {
        ResultModel<Pagination> resultModel = new ResultModel<>();
        List<ActivityDate> activityDates = new ArrayList<>();
        for (ActivityCount activityCount : activityCounts) {
            ActivityDate activityDate = new ActivityDate();
            BeanUtils.copyProperties(activityCount, activityDate);
            activityDate.setPerClickPv(activityCount.getPerClickPv());
            activityDate.setPerClickPvChange(getPerChangeName(activityCount));
            activityDates.add(activityDate);
        }
        Pagination pagination = new Pagination();
        pagination.setList(activityDates);
        resultModel.setReturnValue(pagination);
        return resultModel;
    }

    /**
     * 导出活动报表按日维度
     * 
     * @param activityCounts
     * @param response
     */
    @Override
    public void activityReportByDateExport(List<ActivityCount> activityCounts, HttpServletResponse response) {
        List<ActivityDate> activityDates = new ArrayList<>();
        for (ActivityCount activityCount : activityCounts) {
            ActivityDate activityDate = new ActivityDate();
            BeanUtils.copyProperties(activityCount, activityDate);
            activityDates.add(activityDate);
        }
        // 整合后的数据
        ExcelUtil.exportExcel(activityDates, null, null, ActivityDate.class, "活动报表.xls", response);
    }

    /**
     * 装载活动报表按子链接按日
     * 
     * @param activityCounts
     * @return
     */
    @Override
    public ResultModel pullActivityBusinessByDate(List<ActivityCount> activityCounts) {
        ResultModel<Pagination> resultModel = new ResultModel<>();
        List<ActivityBusinessDate> activityBusinessDates = new ArrayList<>();
        for (ActivityCount activityCount : activityCounts) {
            ActivityBusinessDate activityBusinessDate = new ActivityBusinessDate();
            BeanUtils.copyProperties(activityCount, activityBusinessDate);
            activityBusinessDate.setPerClickPv(activityCount.getPerClickPv());
            activityBusinessDate.setPerClickPvChange(getPerChangeName(activityCount));
            activityBusinessDates.add(activityBusinessDate);
        }
        Pagination pagination = new Pagination();
        pagination.setList(activityBusinessDates);
        resultModel.setReturnValue(pagination);
        return resultModel;
    }

    /**
     * 导出活动报表子链接按日
     * 
     * @param activityCounts
     * @param response
     */
    @Override
    public void activityReportBusinessByDateExport(List<ActivityCount> activityCounts, HttpServletResponse response) {
        List<ActivityBusinessDate> activityBusinessDates = new ArrayList<>();
        for (ActivityCount activityCount : activityCounts) {
            ActivityBusinessDate activityBusinessDate = new ActivityBusinessDate();
            BeanUtils.copyProperties(activityCount, activityBusinessDate);
            activityBusinessDates.add(activityBusinessDate);
        }
        // 整合后的数据
        ExcelUtil.exportExcel(activityBusinessDates, null, null, ActivityBusinessDate.class, "活动报表.xls", response);
    }

    /**
     * 获取礼券IDS
     */
    @Override
    public String getActivityIds(ActivityReportRo activityReportRo) {
        Map<String, Object> map = new HashMap<>();
        if (!StringUtils.isEmpty(activityReportRo.getKeywords())) {
            if (StringUtils.isNumeric(activityReportRo.getKeywords().trim())) {
                map.put("activityid", activityReportRo.getKeywords().trim());
            } else {
                map.put("activityname", activityReportRo.getKeywords().trim());
            }
        }
        if (!StringUtils.isEmpty(activityReportRo.getActivityType())) {
            map.put("activitytype", activityReportRo.getActivityType().trim());
        }
        if (StringUtil.isNotBlank(activityReportRo.getActivityplan())) {
            map.put("activityPlan", activityReportRo.getActivityplan());
        }
        if (StringUtil.isNotBlank(activityReportRo.getActivityDesigner())) {
            map.put("activityDesigner", activityReportRo.getActivityDesigner());
        }

        List<Long> ids = activityMapper.findListBykeywords(map);
        if (ids.isEmpty()) {
            return null;
        }

        return JSON.toJSONString(ids);
    }

    /**
     * 获取开发者APPKEYS
     * 
     * @param appName
     * @return
     */
    @Override
    public String getAppKeys(String appName) {
        if (StringUtils.isNotEmpty(appName)) {
            Map<String, Object> map = new HashMap<>();
            map.put("mediaName", appName.trim());
            List<InfoAppMsg> appMsgs = infoAppMsgMapperExt.findAppkeys(map);
            if (appMsgs.isEmpty()) {
                return null;
            }
            List<String> appKeys = new ArrayList<>();
            for (InfoAppMsg infoAppMsg : appMsgs) {
                appKeys.add(infoAppMsg.getAppkey());
            }
            return JSON.toJSONString(appKeys);
        }
        return null;
    }

    /**
     * 获取开发者子链接
     * 
     * @param appKey
     * @param businessName
     * @return
     */
    @Override
    public String getBusiness(String appKey, String businessName) {
        Map<String, Object> map = new HashMap<>();
        map.put("appKey", appKey);
        if (StringUtils.isNotBlank(businessName)) {
            map.put("businessName", businessName);
        }
        List<AdpositionVo> businesses = adPositionMapperExt.findBusinesses(map);
        if (CollectionUtils.isEmpty(businesses)) {
            return null;
        }
        List<String> list = Lists.newArrayListWithCapacity(businesses.size());
        for (AdpositionVo adpositionVo : businesses) {
            list.add("ad-" + adpositionVo.getBusiness());
        }
        return JSON.toJSONString(list);
    }

    @Override
    public List<InfoActivityMsgDto> getActivityMsg(String keyWords, String activityType, String activityPlan) {

        Map<String, Object> map = new HashMap<>();
        if (!StringUtils.isEmpty(keyWords)) {
            if (StringUtils.isNumeric(keyWords.trim())) {
                map.put("activityid", Integer.parseInt(keyWords.trim()));
            } else {
                map.put("activityname", keyWords.trim());
            }
        }
        if (!StringUtils.isEmpty(activityType)) {
            map.put("activitytype", activityType.trim());
        }
        if (StringUtil.isNotBlank(activityPlan)) {
            map.put("activityPlan", activityPlan);
        }

        List<InfoActivityMsgDto> list = activityMapper.findListBykeywords2(map);
        if (list.isEmpty()) {
            return null;
        }

        return list;
    }

    /**
     * 开发都日报子链接活动按日报表
     * 
     * @param activityCounts
     * @param response
     */
    @Override
    public void appBusinessActivityDateReportExport(List<ActivityCount> activityCounts, HttpServletResponse response) {
        List<AppBusinessActivityDateVo> activityBusinessDates = new ArrayList<>();
        for (ActivityCount activityCount : activityCounts) {
            AppBusinessActivityDateVo activityBusinessDate = new AppBusinessActivityDateVo();
            BeanUtils.copyProperties(activityCount, activityBusinessDate);
            activityBusinessDates.add(activityBusinessDate);
        }
        // 整合后的数据
        ExcelUtil.exportExcel(activityBusinessDates, null, null, AppBusinessActivityDateVo.class, "开发者日报子链接活动按日报表.xls",
                              response);
    }

    private String getPerChangeName(ActivityCount appCount) {
        return appCount.getPerClickPvChange() != null
               && appCount.getPerClickPvChange() != 0.0 ? appCount.getPerClickPvChange() + "%" : "-";
    }

    /**
     * 给vo设置设计者和策划者
     * @param activityWithBLOB
     * @param activityVo
     */
    private void setDesignerAndPlanner(ActivityWithBLOBs activityWithBLOB, ActivityDailyReportVo activityVo){
        if (activityWithBLOB != null) {
            String designer = aclUserIntegration.queryUserByRoleCode("huodongui").get(activityWithBLOB.getActivityDesigner());
            activityVo.setActivityDesigner(designer);
            String planner = aclUserIntegration.queryUserByRoleCode("actplan").get(activityWithBLOB.getActivityPlanner());
            activityVo.setActivityPlanner(planner);
        }
    }

}
