package com.bxm.report.service.datapark.impl;


import com.bxm.report.model.dao.adticket.TicketCountCommon;
import com.bxm.report.model.vo.ticket.TicketCountCommonExportVo;
import com.bxm.report.service.datapark.DataparkTicketService;
import com.bxm.report.service.utils.CollectionDataCopyUtil;
import com.bxm.report.service.utils.ExcelUtil;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * DataparkTicketService实现层
 *
 * @author zhangkai
 * @create 2018-03-02 19:46
 **/
@Service
public class DataparkTicketServiceImpl implements DataparkTicketService {

    @Override
    public void ticketDataExport(List<TicketCountCommon> list, String customExportFieldStr, Integer showIncreaseFlag, HttpServletResponse response) {

        /**
         * 转换参数容器， 因为TicketCountCommon不在adsmanager的model项目模块里， 无法加入ExcelReportIncrease的注解
         */
        List<TicketCountCommonExportVo> exportVos = CollectionDataCopyUtil.copyList(list, TicketCountCommonExportVo.class);

        //整合后的数据
        ExcelUtil.customFieldExport(exportVos, TicketCountCommonExportVo.class, customExportFieldStr, showIncreaseFlag,"广告券报表.xls", response);
    }
}
