package com.bxm.report.service.datapark.impl;

import com.bxm.dao.adkeeper.TblActivityMapper;
import com.bxm.dao.venue.VenueMapper;
import com.bxm.datapark.facade.Page;
import com.bxm.datapark.facade.venue.model.dto.VenueReportDto;
import com.bxm.datapark.facade.venue.model.vo.VenueReportVo;
import com.bxm.report.facade.datapark.DataparkVenuePullerIntegration;
import com.bxm.report.model.dao.activity.TblActivity;
import com.bxm.report.model.dao.venue.VenueDao;
import com.bxm.report.service.datapark.VenueReportService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service
public class VenueReportServiceImpl implements VenueReportService {

    @Autowired
    private DataparkVenuePullerIntegration dataparkVenuePullerIntegration;

    @Autowired
    private VenueMapper venueMapper;

    @Autowired
    private TblActivityMapper tblActivityMapper;

    @Override
    public Page<VenueReportVo> venueReport(VenueReportDto dto){

        //按条件查询主会场信息
        List<VenueDao> venueDaos = venueMapper.findAllForReport(dto.getVenueName());
        if(CollectionUtils.isEmpty(venueDaos)){
            return new Page<>();
        }
        List<String> venueIds = new ArrayList<>();
        for(VenueDao dao :venueDaos){
            venueIds.add(dao.getId().toString());
        }
        dto.setVenueIds(venueIds);
        Page<VenueReportVo> page = dataparkVenuePullerIntegration.venueReport(dto);

        //填充主会场名称数据
        if(CollectionUtils.isNotEmpty(page.getList())) {
            Map<Integer, VenueDao> map = venueDaos.stream().collect(Collectors.toMap(VenueDao::getId, val -> val));
            //按条件过滤数据
            Iterator<VenueReportVo> iterator = page.getList().iterator();
            while (iterator.hasNext()) {
                VenueReportVo vo = iterator.next();
                if(StringUtils.isNumericSpace(vo.getVenueId()) && MapUtils.isNotEmpty(map)) {
                    VenueDao venueDao = map.get(Integer.valueOf(vo.getVenueId()));
                    if(null != venueDao) {
                        vo.setVenueName(venueDao.getName());
                    }
                }
            }
        }

        return page;
    }

    @Override
    public Page<VenueReportVo> venueActivityReport(VenueReportDto dto) {
        Page<VenueReportVo> page = dataparkVenuePullerIntegration.venueReport(dto);
        if(CollectionUtils.isNotEmpty(page.getList())){
            List<String> ids = new ArrayList<>();
            for(VenueReportVo vo :page.getList()){
                if(StringUtils.isNotBlank(vo.getActivityId())){
                    ids.add(vo.getActivityId());
                }
            }
            if(ids.size()>0) {
                List<TblActivity> activiites = tblActivityMapper.findActivityNameByIds(ids);
                Map<Long, String> activiitesMap = activiites.stream().collect(Collectors.toMap(TblActivity::getId, TblActivity::getActivityName));
                for(VenueReportVo vo :page.getList()){
                    if(StringUtils.isNumericSpace(vo.getActivityId())){
                        vo.setActivityName(activiitesMap.get(Long.valueOf(vo.getActivityId())));
                    }
                }
            }
        }
        return page;
    }

    @Override
    public Page<VenueReportVo> venueDateReport(VenueReportDto dto) {
        return dataparkVenuePullerIntegration.venueDateReport(dto);
    }
}
